/*
 * @(#)ExecutionAdminLogin.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.connect.admin ;

import org.maachang.queue.MaachangQ;
import org.maachang.queue.access.net.ConnectObject;
import org.maachang.queue.access.protocol.login.LoginBean;
import org.maachang.queue.access.protocol.login.LoginProtocol;
import org.maachang.queue.connect.ExecutionAdmin;
import org.maachang.queue.connect.admin.login.LoginManager;
import org.maachang.queue.connect.admin.login.LoginSession;
import org.maachang.queue.connect.common.Telegram;


/**
 * ログイン電文処理.
 *
 * @version 2007/01/15
 * @author  Masahito Suzuki
 * @since   MaachangQ 1.00
 */
public class ExecutionAdminLogin implements ExecutionAdmin {
    
    /**
     * コンストラクタ.
     */
    public ExecutionAdminLogin() {
        
    }
    
    /**
     * 管理者実行処理IDを取得.
     * <BR><BR>
     * 設定されている管理者実行処理IDを取得します.
     * <BR>
     * @return int 管理者実行処理IDが返されます.
     */
    public int getId() {
        return LoginProtocol.CATEGORY_TYPE_LOGIN ;
    }
    
    /**
     * 実行処理.
     * <BR><BR>
     * 各管理者用実行処理を実装するためのメソッド.
     * <BR>
     * @param telegramType 処理対象の実行タイプを格納します.
     * @param connect コネクションオブジェクトが設定されます.
     * @param session 対象のログインセッションが設定されます.
     * @param id 対象の電文IDが設定されます.
     * @param telegram 受信された電文が設定されます.
     * @return boolean 処理結果が返されます.
     * @exception Exception 例外.
     */
    public boolean execution( int[] telegramType,LoginSession session,
        ConnectObject connect,int id,Telegram telegram )
        throws Exception {
        
        byte[] binary = telegram.getTelegram() ;
        telegram.clear() ;
        
        // 受信バイナリを解析.
        LoginBean bean = new LoginBean() ;
        LoginProtocol.analysisProtocol( bean,binary ) ;
        telegramType[ 0 ] = bean.getType() ;
        binary = null ;
        
        // シャットダウンコマンド.
        if( bean.isRootOwner() == true ) {
            
            // ユーザチェック.
            LoginManager.checkLoginUser( true,session ) ;
            
            // シャットダウン処理.
            MaachangQ.shutdown() ;
            
        }
        // ログイン処理.
        else {
            
            // ログイン処理.
            LoginManager.login(
                session,bean.getUser(),bean.getPasswd() ) ;
            
            // ログイン正常結果を戻す.
            byte[] result = LoginProtocol.createResultProtocol(
                id,session.getId(),session.isOwner() ) ;
            connect.send( result ) ;
            
        }
        
        return true ;
    }
    
}

