/*
 * @(#)LoginSession.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.connect.admin.login ;

/**
 * ログインセッション.
 *
 * @version 2007/01/14
 * @author  Masahito Suzuki
 * @since   MaachangQ 1.00
 */
public class LoginSession {
    
    /**
     * ログインID.
     */
    private int id = -1 ;
    
    /**
     * ログインユーザ名.
     */
    private String user = null ;
    
    /**
     * ログインパスワード.
     */
    private String passwd = null ;
    
    /**
     * 権限.
     */
    private boolean owner = false ;
    
    /**
     * ログイン時間.
     */
    private long createTime = -1L ;
    
    
    
    /**
     * コンストラクタ.
     */
    public LoginSession() {
        
    }
    
    /**
     * オブジェクト破棄.
     * <BR><BR>
     * オブジェクトを破棄します.
     * <BR>
     * @exception Exception 例外.
     */
    protected void finalize() throws Exception {
        this.clear() ;
    }

    /**
     * セッション生成.
     * <BR><BR>
     * 条件を設定してログインセッションを作成します.
     * <BR>
     * @param id 対象のログインIDを設定します.
     * @param user 対象のログインユーザ名を設定します.
     * @param passwd 対象のログインパスワードを設定します.
     * @param owner 対象の権限を設定します.
     */
    public void create( int id,String user,String passwd,boolean owner ) {
        this.id = id ;
        this.user = user ;
        this.passwd = passwd ;
        this.owner = owner ;
        this.createTime = System.currentTimeMillis() ;
    }

    /**
     * セッションクリア.
     * <BR><BR>
     * セッションをクリアします.
     * <BR>
     * @exception Exception 例外.
     */
    public void clear() {
        this.id = -1 ;
        this.user = null ;
        this.passwd = null ;
        this.owner = false ;
    }

    /**
     * createTimeを取得.
     * <BR><BR>
     * @return createTime が返されます。
     */
    public long getCreateTime() {
        return createTime;
    }

    /**
     * idを取得.
     * <BR><BR>
     * @return id が返されます。
     */
    public int getId() {
        return id;
    }

    /**
     * ownerを取得.
     * <BR><BR>
     * @return owner が返されます。
     */
    public boolean isOwner() {
        return owner;
    }

    /**
     * 権限を設定.
     * <BR><BR>
     * @param owner を設定します.
     */
    public void setOwner( boolean owner ) {
        this.owner = owner ;
    }

    /**
     * passwdを取得.
     * <BR><BR>
     * @return passwd が返されます。
     */
    public String getPasswd() {
        return passwd;
    }

    /**
     * パスワードを再設定.
     * <BR><BR>
     * @param passwd を設定します.
     */
    protected void setPasswd( String passwd ) {
        this.passwd = passwd ;
    }

    /**
     * userを取得.
     * <BR><BR>
     * @return user が返されます。
     */
    public String getUser() {
        return user;
    }

    /**
     * ログインセッション状態を確認.
     * <BR><BR>
     * ログインセッション状態を確認します.
     * <BR>
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]が返された場合、現在ログイン中です.<BR>
     *                 [false]が返された場合、ログインされていません.
     */
    public boolean isSession() {
        return ( user != null && user.length() > 0 ) ?
            true : false ;
    }
}

