/*
 * @(#)ExecutionReceiveClient.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.connect.common ;

import org.maachang.commons.util.CharTable;
import org.maachang.queue.access.net.ConnectObject;
import org.maachang.queue.connect.admin.login.LoginSession;

/**
 * クライアント接続実行インターフェイス.
 *
 * @version 2007/01/14
 * @author  Masahito Suzuki
 * @since   MaachangQ 1.00
 */
public interface ExecutionReceiveClient {
    
    /**
     * スレッド終了処理.
     * <BR><BR>
     * スレッドが終了するときに呼び出されます.
     * <BR>
     * @param session 対象のログインセッションが設定されます.
     * @param tranMan 対象のトランザクションマネージャが設定されます.
     */
    public void exit( LoginSession session,CharTable tranMan ) ;
    
    /**
     * クライアント接続実行処理.
     * <BR><BR>
     * クライアント接続実行処理を行います.
     * <BR>
     * @param telegramType 処理対象の実行タイプを格納します.
     * @param connect コネクションオブジェクトが設定されます.
     * @param session 対象のログインセッションが設定されます.
     * @param tranMan 対象のトランザクションマネージャが設定されます.
     * @param id 対象の電文IDが設定されます.
     * @param type 対象の電文処理タイプが設定されます.
     * @param telegram 受信された電文が設定されます.
     * @exception Exception 例外.
     */
    public void execution( int[] telegramType,LoginSession session,
        CharTable tranMan,ConnectObject connect,int id,int type,
        Telegram telegram )
        throws Exception ;
    
}

