/*
 * @(#)TransactionData.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.connect.common ;

/**
 * トランザクションデータ管理.
 *
 * @version 2007/01/16
 * @author  Masahito Suzuki
 * @since   MaachangQ 1.00
 */
public class TransactionData {
    
    /**
     * トランザクションID.
     */
    private final int[] transactionId = new int[ 1 ] ;
    
    /**
     * キューマネージャ名.
     */
    private String manager = null ;
    
    /**
     * キュー名.
     */
    private String queue = null ;
    
    /**
     * キュータイプ.
     */
    private int queueType = -1 ;
    
    /**
     * コンストラクタ.
     */
    public TransactionData() {
        this.clear() ;
        manager = null ;
        queue = null ;
        queueType = -1 ;
    }
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報をクリアします.
     */
    public void clear() {
        transactionId[ 0 ] = -1 ;
    }

    /**
     * managerを取得.
     * <BR><BR>
     * @return manager が返されます。
     */
    public String getManager() {
        return manager;
    }

    /**
     * managerを設定.
     * <BR><BR>
     * @param manager 対象のmanagerを設定.
     */
    public void setManager(String manager) {
        this.manager = manager;
    }

    /**
     * queueを取得.
     * <BR><BR>
     * @return queue が返されます。
     */
    public String getQueue() {
        return queue;
    }

    /**
     * queueを設定.
     * <BR><BR>
     * @param queue 対象のqueueを設定.
     */
    public void setQueue(String queue) {
        this.queue = queue;
    }

    /**
     * queueTypeを取得.
     * <BR><BR>
     * @return queueType が返されます。
     */
    public int getQueueType() {
        return queueType;
    }

    /**
     * queueTypeを設定.
     * <BR><BR>
     * @param queueType 対象のqueueTypeを設定.
     */
    public void setQueueType(int queueType) {
        this.queueType = queueType;
    }

    /**
     * transactionIdを取得.
     * <BR><BR>
     * @return transactionId が返されます。
     */
    public int[] getTranIds() {
        return transactionId;
    }

    /**
     * transactionIdを取得.
     * <BR><BR>
     * @return transactionId が返されます。
     */
    public int getTranId() {
        return transactionId[ 0 ];
    }

    /**
     * transactionIdを設定.
     * <BR><BR>
     * @param transactionId 対象のtransactionIdを設定.
     */
    public void setTranId(int transactionId) {
        this.transactionId[ 0 ] = transactionId;
    }
    
}

