/*
 * @(#)MqCacheBean.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.cache ;

import java.io.Serializable;

import org.maachang.commons.serialize.SerializeUtil;

/**
 * キューキャッシュBean.
 * 
 * @version 2006/09/05
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public class MqCacheBean implements Serializable {
    
    static {
        serialVersionUID = SerializeUtil.serialVersionUID(
            MqCacheBean.class.getName()
        ) ;
    }
    
    /**
     * シリアライズUID.
     */
    private static final long serialVersionUID ;
    
    /**
     * キューキャッシュ名.
     */
    private String queueCacheName = null ;
    
    /**
     * キャッシュセクタ数.
     */
    private int cacheSize = -1 ;
    
    /**
     * コンストラクタ.
     */
    public MqCacheBean() {
        
    }
    
    /**
     * cacheSizeを取得.
     * <BR><BR>
     * @return cacheSize が返されます。
     */
    public int getCacheSize() {
        return cacheSize;
    }
    
    /**
     * cacheSizeを設定.
     * <BR><BR>
     * @param cacheSize 対象のcacheSizeを設定.
     */
    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize ;
    }
    
    /**
     * queueCacheNameを取得.
     * <BR><BR>
     * @return queueCacheName が返されます。
     */
    public String getQueueCacheName() {
        return queueCacheName;
    }
    
    /**
     * queueCacheNameを設定.
     * <BR><BR>
     * @param queueCacheName 対象のqueueCacheNameを設定.
     */
    public void setQueueCacheName(String queueCacheName) {
        if(
            queueCacheName == null ||
            ( queueCacheName = queueCacheName.trim().toLowerCase() ).length() <= 0 ) {
            return ;
        }
        this.queueCacheName = queueCacheName;
    }
    
}

