/*
 * @(#)Channel.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.channel ;

import org.maachang.commons.thread.Synchronized;
import org.maachang.queue.access.MaachangQAccessDefine;

/**
 * チャネルインターフェイス.
 * 
 * @version 2006/09/02
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public interface Channel {
    
    /**
     * チャネルタイプ : 受信チャネル.
     */
    public static final int TYPE_RECEIVE = MaachangQAccessDefine.TYPE_RECEIVE ;
    
    /**
     * チャネルタイプ : 送信チャネル.
     */
    public static final int TYPE_SEND = MaachangQAccessDefine.TYPE_SEND ;
    
    
    
    /**
     * チャネル名を取得.
     * <BR><BR>
     * チャネル名を取得します.
     * <BR>
     * @return String チャネル名が返されます.
     */
    public String getName() ;
    
    /**
     * チャネルIDを取得.
     * <BR><BR>
     * チャネルIDを取得します.
     * <BR>
     * @return int チャネルIDが返されます.
     */
    public int getId() ;
    
    /**
     * チャネルタイプを取得.
     * <BR><BR>
     * チャネルタイプを取得します.
     * <BR>
     * @return int チャネルタイプが返されます.
     */
    public int getType() ;
    
    /**
     * ステータスを設定.
     * <BR><BR>
     * チャネルステータスを設定します.
     * <BR>
     * @param state 対象のチャネルステータスを設定します.
     */
    public void setState( int state ) ;
    
    /**
     * ステータスを取得.
     * <BR><BR>
     * 現在のチャネルステータスが返されます.
     * <BR>
     * @return int チャネルステータスが返されます.<BR>
     *             [STATE_SUCCESS]が返された場合、「正常」です.<BR>
     *             [STATE_DOWN]が返された場合、「停止」です.<BR>
     *             [STATE_STARTUP]が返された場合、「起動中」です.<BR>
     *             [STATE_SHUTDOWN]が返された場合、「停止」です.<BR>
     *             [STATE_ERROR]が返された場合、「異常」です.<BR>
     *             [STATE_NOT_HEART_BEAT]が返された場合、「接続未確立による停止」です.<BR>
     *             [STATE_NOT_CONNECT_CHANNEL]が返された場合、「接続先チャネル
     *             非存在による停止」です.
     */
    public int getState() ;
    
    /**
     * チャネルBeanオブジェクトを取得.
     * <BR><BR>
     * チャネルBeanオブジェクトを取得します.
     * <BR>
     * @return ChannelBean チャネルBeanオブジェクトが返されます.
     */
    public ChannelBean getChannelBean() ;
    
    /**
     * チャネルBeanオブジェクトを取得.
     * <BR><BR>
     * チャネルBeanオブジェクトを取得します.
     * <BR>
     * @param bean 設定対象のBeanを設定します.
     */
    public void getBean( ChannelBean bean ) ;
    
    /**
     * 最終受信ID管理オブジェクトを取得.
     * <BR><BR>
     * 最終受信ID管理オブジェクトを取得します.
     * <BR>
     * @return LastReceiveIdManage 最終受信ID管理オブジェクトが返されます.
     */
    public LastReceiveIdManage getLastReceiveIdManage() ;
    
    /**
     * 同期オブジェクトを取得.
     * <BR><BR>
     * 同期オブジェクトを取得します.
     * <BR>
     * @return Synchronized 同期オブジェクトが返されます.
     */
    public Synchronized getSynchronized() ;
    
    /**
     * チャネルオブジェクトが有効であるか取得.
     * <BR><BR>
     * チャネルオブジェクトが有効であるか取得します.
     * <BR>
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]が返された場合、有効です.<BR>
     *                 [false]が返された場合、無効です.
     */
    public boolean isChannel() ;
    
}

