/*
 * @(#)ChannelBean.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.channel ;

import java.io.Serializable;

import org.maachang.commons.serialize.SerializeUtil;
import org.maachang.queue.main.connect.Connect;

/**
 * チャネルBean.
 * 
 * @version 2006/09/02
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public class ChannelBean implements Serializable {
    
    static {
        serialVersionUID = SerializeUtil.serialVersionUID(
            ChannelBean.class.getName()
        ) ;
    }
    
    /**
     * シリアライズUID.
     */
    private static final long serialVersionUID ;
    
    /**
     * チャネル名.
     */
    private String channelName = null ;
    
    /**
     * 接続先キューマネージャ名.
     */
    private String queueManager = null ;
    
    /**
     * チャネルタイプ.
     */
    private int type = -1 ;
    
    /**
     * 接続先アドレス.
     */
    private String connectAddress = null ;
    
    /**
     * 接続先ポート番号.
     */
    private int connectPort = Connect.DEF_PORT ;
    
    /**
     * 接続通信オブジェクト名.
     */
    private String connectObjectName = null ;
    
    /**
     * 利用暗号ワード.
     */
    private String useCb32Word = null ;
    
    /**
     * コンストラクタ.
     */
    public ChannelBean() {
        
    }
    
    /**
     * channelNameを取得.
     * <BR><BR>
     * @return channelName が返されます。
     */
    public String getChannelName() {
        return channelName;
    }
    
    /**
     * channelNameを設定.
     * <BR><BR>
     * @param channelName 対象のchannelNameを設定.
     */
    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }
    
    /**
     * connectAddressを取得.
     * <BR><BR>
     * @return connectAddress が返されます。
     */
    public String getConnectAddress() {
        return connectAddress;
    }
    
    /**
     * connectAddressを設定.
     * <BR><BR>
     * @param connectAddress 対象のconnectAddressを設定.
     */
    public void setConnectAddress(String connectAddress) {
        this.connectAddress = connectAddress;
    }
    
    /**
     * connectObjectNameを取得.
     * <BR><BR>
     * @return connectObjectName が返されます。
     */
    public String getConnectObjectName() {
        return connectObjectName;
    }
    
    /**
     * connectObjectNameを設定.
     * <BR><BR>
     * @param connectObjectName 対象のconnectObjectNameを設定.
     */
    public void setConnectObjectName(String connectObjectName) {
        this.connectObjectName = connectObjectName;
    }
    
    /**
     * connectPortを取得.
     * <BR><BR>
     * @return connectPort が返されます。
     */
    public int getConnectPort() {
        return connectPort;
    }
    
    /**
     * connectPortを設定.
     * <BR><BR>
     * @param connectPort 対象のconnectPortを設定.
     */
    public void setConnectPort(int connectPort) {
        this.connectPort = connectPort;
    }

    /**
     * typeを取得.
     * <BR><BR>
     * @return type が返されます。
     */
    public int getType() {
        return type;
    }

    /**
     * typeを設定.
     * <BR><BR>
     * @param type 対象のtypeを設定.
     */
    public void setType(int type) {
        this.type = type;
    }

    /**
     * queueManagerを取得.
     * <BR><BR>
     * @return queueManager が返されます。
     */
    public String getQueueManager() {
        return queueManager;
    }

    /**
     * queueManagerを設定.
     * <BR><BR>
     * @param queueManager 対象のqueueManagerを設定.
     */
    public void setQueueManager(String queueManager) {
        this.queueManager = queueManager;
    }

    /**
     * useCb32Wordを取得.
     * <BR><BR>
     * @return useCb32Word が返されます。
     */
    public String getUseCb32Word() {
        return useCb32Word;
    }

    /**
     * useCb32Wordを設定.
     * <BR><BR>
     * @param useCb32Word 対象のuseCb32Wordを設定.
     */
    public void setUseCb32Word(String useCb32Word) {
        this.useCb32Word = useCb32Word;
    }
    
}

