/*
 * @(#)ChannelKey.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.channel ;

import java.io.Serializable;

import org.maachang.commons.serialize.SerializeUtil;

/**
 * Key要素情報.
 * <BR><BR>
 * Key要素情報を表すオブジェクト.
 *  
 * @version 2006/09/03
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public class ChannelKey implements Serializable {
    
    static {
        serialVersionUID = SerializeUtil.serialVersionUID(
            ChannelKey.class.getName()
        ) ;
    }
    
    /**
     * シリアライズUID.
     */
    private static final long serialVersionUID ;
    
    /**
     * チャネルタイプ.
     */
    private int channelType = -1 ;
    
    /**
     * チャネル名.
     */
    private String name = null ;
    
    /**
     * コンストラクタ.
     */
    protected ChannelKey() {
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * @param channelType チャネルタイプを設定します.
     * @param name チャネル名を設定します.
     */
    protected ChannelKey( int channelType,String name ) {
        this.channelType = channelType ;
        this.name = name ;
    }
    
    /**
     * 情報破棄.
     * <BR><BR>
     * 情報を破棄します.
     */
    protected void finalize() throws Exception {
        channelType = -1 ;
        name = null ;
    }
    
    /**
     * キュー名を取得.
     * <BR><BR>
     * @return String キュー名が返されます.
     */
    public String getName() {
        return name;
    }
    
    /**
     * チャネルタイプを取得.
     * <BR><BR>
     * @return int チャネルタイプが返されます.
     */
    public int getChannelType() {
        return channelType;
    }
    
}

