/*
 * @(#)Channel.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.channel ;

import java.net.InetAddress;

/**
 * 送信チャネルインターフェイス.
 * 
 * @version 2006/09/02
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public interface SendChannel {
    
    /**
     * キューマネージャ名を取得.
     * <BR><BR>
     * キューマネージャ名を取得します.
     * <BR>
     * @param name 対象のキューマネージャ名を設定します.
     */
    public void setQueueManager( String name ) ;
    
    /**
     * キューマネージャ名を取得.
     * <BR><BR>
     * キューマネージャ名を取得します.
     * <BR>
     * @param String 接続先のキューマネージャ名を取得します.
     */
    public String getQueueManager() ;
    
    /**
     * 接続先IPアドレスを設定.
     * <BR><BR>
     * 接続先のIPアドレスを設定します.
     * <BR>
     * @param addr 接続先のIPアドレスを設定します.
     */
    public void setInetAddress( InetAddress addr ) ;
    
    /**
     * 接続先IPアドレスを取得.
     * <BR><BR>
     * 接続先のIPアドレスを取得します.
     * <BR>
     * @return InetAddress 接続先のIPアドレスが返されます.
     */
    public InetAddress getInetAddress() ;
    
    /**
     * 接続先ポート番号を設定.
     * <BR><BR>
     * 接続先のポート番号を設定します.
     * <BR>
     * @param port 接続先のポート番号を設定します.
     */
    public void setPort( int port ) ;
    
    /**
     * 接続先ポート番号を取得.
     * <BR><BR>
     * 接続先のポート番号を取得します.
     * <BR>
     * @return int 接続先のポート番号が返されます.
     */
    public int getPort() ;
    
    /**
     * 通信オブジェクト名を設定.
     * <BR><BR>
     * 通信処理を行うオブジェクト名を設定します.
     * <BR>
     * @return connectName 通信オブジェクトを設定します.
     */
    public void setConnectName( String connectName ) ;
    
    /**
     * 通信オブジェクト名を取得.
     * <BR><BR>
     * 通信処理を行うオブジェクト名を取得します.
     * <BR>
     * @return String 通信オブジェクト名が返されます.
     */
    public String getConnectName() ;
    
    /**
     * 利用暗号ワードを設定.
     * <BR><BR>
     * 利用暗号ワードを設定します.
     * <BR>
     * @param useCb32Word 対象の利用暗号ワードを設定します.
     */
    public void setUseCb32Word( String useCb32Word ) ;
    
    /**
     * 利用暗号ワードを取得.
     * <BR><BR>
     * 利用暗号ワードを取得します.
     * <BR>
     * @return String String 利用暗号ワードが返されます.
     */
    public String getUseCb32Word() ;
    
    /**
     * シーケンスIDを取得.
     * <BR><BR>
     * シーケンスID情報を取得します.
     * <BR>
     * @return long シーケンスIDが返されます.
     */
    public long getSequenceID() ;
    
    /**
     * オプション情報を設定.
     * <BR><BR>
     * オプション情報を設定します.
     * <BR>
     * @param option 対象のオプション情報を設定します
     */
    public void setOption( Object option ) ;
    
    /**
     * オプション情報を取得.
     * <BR><BR>
     * オプション情報を取得します.
     * <BR>
     * @return Object オプション情報が返されます.
     */
    public Object getOption() ;
    
    /**
     * チャネルBeanオブジェクトを取得.
     * <BR><BR>
     * チャネルBeanオブジェクトを取得します.
     * <BR>
     * @param bean 設定対象のBeanを設定します.
     */
    public void getBean( ChannelBean bean ) ;
    
    /**
     * CB32ワードが設定可能かチェック.
     * <BR><BR>
     * CB32ワードが設定可能かチェックします.
     * <BR>
     * @param connect 対象のコネクション名を設定します.
     * @param word チェック対象のワードを設定します.
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]が返された場合、設定可能です.<BR>
     *                 [false]が返された場合、設定不可です.
     */
    public boolean isCb32Word( String connect,String word ) ;
    
}

