/*
 * @(#)ProtocolObject.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.channel.protocol ;

/**
 * チャネル通信プロトコルインターフェイス.
 * 
 * @version 2006/08/31
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public interface ProtocolObject {
    
    /**
     * プロトコルタイプ : データ.
     */
    public static final int PROTOCOL_DATA = 0x00000001 ;
    
    /**
     * プロトコルタイプ : ハートビート.
     */
    public static final int PROTOCOL_HEARTBEAT = 0x00000002 ;
    
    /**
     * プロトコルタイプ : 正常.
     */
    public static final int PROTOCOL_SUCCESS = 0x00000003 ;
    
    /**
     * プロトコルタイプ : エラー.
     */
    public static final int PROTOCOL_ERROR = 0x00000004 ;
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報をクリアします.
     */
    public void clear() ;
    
    /**
     * 電文ID情報を取得.
     * <BR><BR>
     * 電文ID情報を取得します.
     * <BR>
     * @return long 電文ID情報が返されます.
     */
    public long getId() ;
    
    /**
     * 電文ID情報を設定.
     * <BR><BR>
     * 電文ID情報を設定します.
     * <BR>
     * @param id 対象の電文IDを設定します.
     */
    public void setId(long id) ;
    
    /**
     * 処理名を取得.
     * <BR><BR>
     * 処理名を取得します.
     * <BR>
     * @return String 処理名が返されます.
     */
    public String getName() ;
    
    /**
     * 処理名を設定.
     * <BR><BR>
     * 処理名を設定します.
     * <BR>
     * @param name キュー名を設定します.
     */
    public void setName(String name) ;
    
    /**
     * キューマネージャ名を取得.
     * <BR><BR>
     * キューマネージャ名を取得します.
     * <BR>
     * @return String キューマネージャ名が返されます.
     */
    public String getQueueManagerName() ;
    
    /**
     * キューマネージャ名を設定.
     * <BR><BR>
     * キューマネージャ名を設定します.
     * <BR>
     * @param queueManagerName キューマネージャ名を設定します.
     */
    public void setQueueManagerName( String queueManagerName ) ;
    
    /**
     * チャネル名を設定.
     * <BR><BR>
     * チャネル名を設定します.
     * <BR>
     * @param channelName 対象のチャネル名を設定します.
     */
    public void setChannelName( String channelName ) ;
    
    /**
     * チャネル名を取得.
     * <BR><BR>
     * チャネル名を取得します.
     * <BR>
     * @return String チャネル名が返されます.
     */
    public String getChannelName() ;
    
    /**
     * 受信ポート番号を取得.
     * <BR><BR>
     * 受信ポート番号を取得します.
     * <BR>
     * @return int 受信ポート番号が返されます.
     */
    public int getReceivePort() ;
    
    /**
     * 受信ポート番号を設定.
     * <BR><BR>
     * 受信ポート番号を設定します.
     * <BR>
     * @param port 受信ポート番号を設定します.
     */
    public void setReceivePort( int port ) ;
    
    /**
     * チャネルIDを取得
     * <BR><BR>
     * チャネルIDを取得します.
     * <BR>
     * @return int チャネルIDが返されます.
     */
    public int getChannelId() ;
    
    /**
     * チャネルIDを設定.
     * <BR><RB>
     * チャネルIDを設定します.
     * <BR>
     * @param channelId 対象のチャネルIDを設定します.
     */
    public void setChannelId( int channelId ) ;
    
    /**
     * プロトコルタイプを取得.
     * <BR><BR>
     * プロトコルタイプを取得します.
     * <BR>
     * @return int プロトコルタイプが返されます.<BR>
     *             [ProtocolObject.PROTOCOL_DATA]が返された場合、データオブジェクトです.<BR>
     *             [ProtocolObject.PROTOCOL_HEARTBEAT]が返された場合、ハートビートオブジェクトです.<BR>
     *             [ProtocolObject.PROTOCOL_SUCCESS]が返された場合、正常オブジェクトです.<BR>
     *             [ProtocolObject.PROTOCOL_ERROR]が返された場合ｍエラーオブジェクトです.
     */
    public int getType() ;
    
    /**
     * プロトコル戻りタイプを取得.
     * <BR><BR>
     * プロトコル戻りタイプを取得します.
     * <BR>
     * @return int プロトコル戻りタイプが返されます.
     */
    public int getReturnType() ;
    
}

