/*
 * @(#)ChannelServiceError.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.channel.service ;


/**
 * チャネルサービスエラー定義.
 *  
 * @version 2006/12/23
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public class ChannelServiceError {
    
    /**
     * コンストラクタ.
     */
    private ChannelServiceError() {
        
    }
    
    ///////////////
    // 基本コード.
    ///////////////
    
    /**
     * コネクション系エラーコード値.
     */
    public static final int CONNECT_ERROR = 0x10000000 ;
    
    /**
     * チャネル系エラーコード値.
     */
    public static final int CHANNEL_ERROR = 0x20000000 ;
    
    /**
     * キュー系エラーコード値.
     */
    public static final int QUEUE_ERROR = 0x30000000 ;
    
    /**
     * キューマネージャ系エラーコード値.
     */
    public static final int QUEUE_MANAGER_ERROR = 0x40000000 ;
     
    
    /////////////////////
    // チャネル系エラー.
    /////////////////////
    
    /**
     * エラーコード : チャネル名は存在しない.
     */
    public static final int NOT_CHANNEL_NAME = CHANNEL_ERROR + 1 ;
    
    /**
     * エラーコード : チャネルステータスが「正常」以外の場合.
     */
    public static final int CHANNEL_STATE_BY_NOT_SUCCESS = CHANNEL_ERROR + 2 ;
    
    
    ////////////////////////////
    // キュー系エラー.
    ////////////////////////////
    
    /**
     * エラーコード : キュー名は存在しない.
     */
    public static final int NOT_QUEUE_NAME = QUEUE_ERROR + 1 ;
    
    /**
     * エラーコード : キューステータスが「正常」以外の場合.
     */
    public static final int QUEUE_STATE_BY_NOT_SUCCESS = QUEUE_ERROR + 2 ;
    
    /**
     * エラーコード : キュー満杯.
     */
    public static final int QUEUE_STATE_BY_FULL = QUEUE_ERROR + 3 ;
    
    /**
     * エラーコード : 指定メッセージ長を越している電文である場合.
     */
    public static final int QUEUE_STATE_BY_MAX_LENGTH = QUEUE_ERROR + 4 ;
    
    
    
    ////////////////////////////
    // キューマネージャ系エラー.
    ////////////////////////////
    
    /**
     * エラーコード : キューマネージャ名は存在しない.
     */
    public static final int NOT_QUEUE_MANAGER_NAME = QUEUE_MANAGER_ERROR + 1 ;
    
    /**
     * エラーコード : キューマネージャステータスが「正常」以外の場合.
     */
    public static final int QUEUE_MANAGER_STATE_BY_NOT_SUCCESS = QUEUE_MANAGER_ERROR + 2 ;
    
    
}

