/*
 * @(#)ExecutionSwitch.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.channel.service.receive ;

import org.maachang.commons.thread.Synchronized;
import org.maachang.queue.main.channel.service.receive.core.CoreReceiveChild;

/**
 * 受信電文処理実装用インターフェイス.
 *
 * @version 2006/12/21
 * @author  Masahito Suzuki
 * @since   MaachangQ 1.00
 */
public interface ExecutionSwitch {
    
    /**
     * プロトコルタイプを取得.
     * <BR><BR>
     * プロトコルタイプを取得します.
     * <BR>
     * @return int プロトコルタイプが返されます.<BR>
     *             [ProtocolObject.PROTOCOL_DATA]が返された場合、データオブジェクトです.<BR>
     *             [ProtocolObject.PROTOCOL_HEARTBEAT]が返された場合、ハートビートオブジェクトです.<BR>
     *             [ProtocolObject.PROTOCOL_SUCCESS]が返された場合、正常オブジェクトです.<BR>
     *             [ProtocolObject.PROTOCOL_ERROR]が返された場合ｍエラーオブジェクトです.
     */
    public int getType() ;
    
    /**
     * 実行処理.
     * <BR><BR>
     * @param threadNum スレッド項番が設定されます.
     * @param child 処理対象の要素が設定されます.
     * @param sync 同期オブジェクト.
     */
    public void execution( int threadNum,CoreReceiveChild child,Synchronized sync ) ;
    
}

