/*
 * @(#)ChannelOption.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.channel.service.send ;

import org.maachang.queue.main.channel.protocol.ProtocolHeartBeat;

/**
 * チャネルオプション.
 * <BR><BR>
 * サービス間で利用するオプションを設定します.
 *
 * @version 2006/12/21
 * @author  Masahito Suzuki
 * @since   MaachangQ 1.00
 */
public class ChannelOption {
	
	/**
	 * カウント最大値.
	 */
	private static final int MAX_COUNT = 999 ;
    
    /**
     * チャネル処理開始時間.
     */
    private long startTime = -1 ;
    
    /**
     * 送信回数.
     */
    private int sendCount = 0 ;
    
    /**
     * 送信用プロトコル管理オブジェクト.
     */
    private ProtocolHeartBeat sendProtocol = null ;

    /**
     * sendProtocolを取得.
     * <BR><BR>
     * @return sendProtocol が返されます。
     */
    public synchronized ProtocolHeartBeat getSendProtocol() {
        return sendProtocol;
    }

    /**
     * sendProtocolを設定.
     * <BR><BR>
     * @param sendProtocol 対象のsendProtocolを設定.
     */
    public synchronized void setSendProtocol(ProtocolHeartBeat sendProtocol) {
        this.sendProtocol = sendProtocol;
    }

    /**
     * startTimeを取得.
     * <BR><BR>
     * @return startTime が返されます。
     */
    public synchronized long getStartTime() {
        return startTime;
    }

    /**
     * startTimeを設定.
     * <BR><BR>
     * @param startTime 対象のstartTimeを設定.
     */
    public synchronized void setStartTime(long startTime) {
        this.startTime = startTime;
    }

	/**
	 * sendCountを取得.
	 * <BR><BR>
	 * @return sendCount が返されます。
	 */
	public synchronized int getSendCount() {
		return sendCount;
	}
	
	/**
	 * 送信カウントを１インクリメント.
	 */
	public synchronized void addSendCount() {
		this.sendCount ++ ;
		if( this.sendCount >= MAX_COUNT ) {
			this.sendCount = MAX_COUNT ;
		}
	}
	
	/**
	 * 送信カウントをクリア.
	 */
	public synchronized void clearSendCount() {
		this.sendCount = 0 ;
	}
    
}

