/*
 * @(#)SendQueueParam.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.channel.service.send ;

import org.maachang.queue.main.queue.base.core.QSendSeq;

/**
 * 送信対象QArrayChildパラメータ.
 *
 * @version 2006/12/22
 * @author  Masahito Suzuki
 * @since   MaachangQ 1.00
 */
public class SendQueueParam {
    
    /**
     * 送信ID.
     */
    private long sendId = 0L ;
    
    /**
     * 送信チャネルID.
     */
    private int[] sendChannelId = null ;
    
    /**
     * 処理開始時間.
     */
    private long createTime = -1L ;
    
    /**
     * 更新時間.
     */
    private long updateTime = -1L ;
    
    /**
     * 処理中フラグ.
     */
    private boolean execution = false ;
    
    /**
     * コンストラクタ.
     */
    public SendQueueParam() {
        this.create() ;
    }

    /**
     * 再定義.
     */
    public void create() {
        createTime = System.currentTimeMillis() ;
        updateTime = -1L ;
        sendId = 0L ;
    }

    /**
     * sendChannelIdを取得.
     * <BR><BR>
     * @return sendChannelId が返されます。
     */
    public synchronized int[] getSendChannelId() {
        return sendChannelId;
    }

    /**
     * sendChannelIdを設定.
     * <BR><BR>
     * @param sendChannelId 対象のsendChannelIdを設定.
     */
    public synchronized void setSendChannelId(int[] sendChannelId) {
        this.sendChannelId = sendChannelId;
    }

    /**
     * sendIdを取得.
     * <BR><BR>
     * @return sendId が返されます。
     */
    public synchronized long getSendId() {
        return sendId;
    }

    /**
     * sendIdを設定.
     * <BR><BR>
     * @param sendId 対象のsendIdを設定.
     */
    public synchronized void setSendId(long sendId) {
        this.sendId = sendId;
    }

    /**
     * createTimeを取得.
     * <BR><BR>
     * @return createTime が返されます。
     */
    public synchronized long getCreateTime() {
        return createTime;
    }

    /**
     * updateTimeを取得.
     * <BR><BR>
     * @return updateTime が返されます。
     */
    public synchronized long getUpdateTime() {
        return updateTime;
    }

    /**
     * updateTimeを更新.
     */
    public synchronized void updateTime() {
        updateTime = System.currentTimeMillis() ;
    }

    /**
     * executionを取得.
     * <BR><BR>
     * @return execution が返されます。
     */
    public synchronized boolean isExecution() {
        return execution;
    }

    /**
     * executionを設定.
     * <BR><BR>
     * @param execution 対象のexecutionを設定.
     */
    public synchronized void setExecution(boolean execution) {
        this.execution = execution;
    }
    
    /**
     * 送信IDから現在の送信IDを取得.
     * <BR><BR>
     * @return int 現在の送信IDが返されます.
     */
    public synchronized int getNowSendId() {
    	return QSendSeq.getNowNextIdByNowId( this.sendId ) ;
    }
    
}

