/*
 * @(#)ConnectBean.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.connect ;

import java.io.Serializable;

import org.maachang.commons.serialize.SerializeUtil;
import org.maachang.queue.main.manager.QueueManagerBean;

/**
 * コネクションBean.
 * 
 * @version 2006/09/02
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public class ConnectBean implements Serializable {
    
    static {
        serialVersionUID = SerializeUtil.serialVersionUID(
            QueueManagerBean.class.getName()
        ) ;
    }
    
    /**
     * シリアライズUID.
     */
    private static final long serialVersionUID ;
    
    /**
     * 接続通信オブジェクト名.
     */
    private String connectObjectName = null ;
    
    /**
     * MqCache名.
     */
    private String mqCacheName = null ;
    
    /**
     * バインドポート.
     */
    private int port = Connect.DEF_PORT ;
    
    /**
     * バインドアドレス.
     */
    private String bindAddress = null ;
    
    /**
     * 送受信バッファ.
     */
    private int bufferLength = ConnectImple.DEF_BUFFER ;
    
    /**
     * 暗号モード.
     */
    private boolean cb32 = false ;
    
    /**
     * 暗号ワード.
     */
    private String[] cb32Word = null ;
    
    
    
    /**
     * コンストラクタ.
     */
    public ConnectBean() {
        
    }
    
    /**
     * bindAddressを取得.
     * <BR><BR>
     * @return bindAddress が返されます。
     */
    public String getBindAddress() {
        return bindAddress;
    }



    /**
     * bindAddressを設定.
     * <BR><BR>
     * @param bindAddress 対象のbindAddressを設定.
     */
    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }



    /**
     * bufferLengthを取得.
     * <BR><BR>
     * @return bufferLength が返されます。
     */
    public int getBufferLength() {
        return bufferLength;
    }



    /**
     * bufferLengthを設定.
     * <BR><BR>
     * @param bufferLength 対象のbufferLengthを設定.
     */
    public void setBufferLength(int bufferLength) {
        this.bufferLength = bufferLength;
    }



    /**
     * connectObjectNameを取得.
     * <BR><BR>
     * @return connectObjectName が返されます。
     */
    public String getConnectObjectName() {
        return connectObjectName;
    }



    /**
     * connectObjectNameを設定.
     * <BR><BR>
     * @param connectObjectName 対象のconnectObjectNameを設定.
     */
    public void setConnectObjectName(String connectObjectName) {
        this.connectObjectName = connectObjectName;
    }



    /**
     * mqCacheNameを取得.
     * <BR><BR>
     * @return mqCacheName が返されます。
     */
    public String getMqCacheName() {
        return mqCacheName;
    }



    /**
     * mqCacheNameを設定.
     * <BR><BR>
     * @param mqCacheName 対象のmqCacheNameを設定.
     */
    public void setMqCacheName(String mqCacheName) {
        this.mqCacheName = mqCacheName;
    }



    /**
     * portを取得.
     * <BR><BR>
     * @return port が返されます。
     */
    public int getPort() {
        return port;
    }



    /**
     * portを設定.
     * <BR><BR>
     * @param port 対象のportを設定.
     */
    public void setPort(int port) {
        this.port = port;
    }

    /**
     * cb32を取得.
     * <BR><BR>
     * @return cb32 が返されます。
     */
    public boolean isCb32() {
        return cb32;
    }

    /**
     * cb32を設定.
     * <BR><BR>
     * @param cb32 対象のcb32を設定.
     */
    public void setCb32(boolean cb32) {
        this.cb32 = cb32;
    }

    /**
     * cb32Wordを取得.
     * <BR><BR>
     * @return cb32Word が返されます。
     */
    public String[] getCb32Word() {
        return cb32Word;
    }

    /**
     * cb32Wordを設定.
     * <BR><BR>
     * @param cb32Word 対象のcb32Wordを設定.
     */
    public void setCb32Word(String[] cb32Word) {
        this.cb32Word = cb32Word;
    }

}

