/*
 * @(#)ManagerService.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.manager.service ;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.commons.sys.NamingManager;

/**
 * マネージャサービス.
 *  
 * @version 2007/01/25
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public class ManagerService {
    
    /**
     * ログオブジェクト.
     */
    private static final Log LOG = LogFactory.getLog( ManagerService.class ) ;
    
    /**
     * ネーミングマネージャ登録名.
     */
    public static final String NAMING_MANAGER = "SERVICE@maachangq.main.manager.service" ;
    
    /**
     * 同期オブジェクト.
     */
    private static final Object SYNC = new Object() ;
    
    /**
     * コンストラクタ.
     */
    public ManagerService() { }
    
    
    /**
     * 初期化処理.
     * <BR><BR>
     * 初期化処理を行います.
     */
    public void init() {
        
        LOG.info( "#### MaachangQキューマネージャサービス生成処理 ####" ) ;
        
        this.destroy( false ) ;
        
        MonitorManagerThread th = new MonitorManagerThread() ;
        
        // ネーミングマネージャに登録.
        synchronized( SYNC ) {
            
            NamingManager.add( NAMING_MANAGER,th ) ;
            
        }
        
    }
    
    /**
     * 終了化処理.
     * <BR><BR>
     * 終了化処理を行います.
     */
    public void destroy() {
        this.destroy( true ) ;
    }
    
    /**
     * 終了化処理.
     * <BR><BR>
     * 終了化処理を行います.
     * <BR>
     * @param mode ログ表示モードを設定します.
     */
    public void destroy( boolean mode ) {
        
        if( mode == true ) {
            LOG.info( "#### MaachangQキューマネージャサービス破棄処理 ####" ) ;
            
            // すべてのキューマネージャステータスをシャットダウン中に設定.
            MonitorManagerThread th = ( MonitorManagerThread )NamingManager.get(
                NAMING_MANAGER ) ;
            if( th != null ) {
                try {
                    th.shutdownManager() ;
                } catch( Exception e ) {
                }
            }
        }
        
        // ネーミングマネージャから削除.
        synchronized( SYNC ) {
            
            NamingManager.remove( NAMING_MANAGER ) ;
            
        }
        
    }
}

