/*
 * @(#)AdminQueueBean.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.queue ;

import java.io.Serializable;

import org.maachang.commons.serialize.SerializeUtil;
import org.maachang.queue.config.MqDefine;

/**
 * キューBean情報.
 *  
 * @version 2006/09/04
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public abstract class QueueBean implements Serializable {
    
    static {
        serialVersionUID = SerializeUtil.serialVersionUID(
            QueueBean.class.getName()
        ) ;
    }
    
    /**
     * シリアライズUID.
     */
    private static final long serialVersionUID ;
    
    /**
     * キュータイプ.
     */
    protected int type = -1 ;
    
    /**
     * GZIP圧縮モード.
     */
    protected boolean gzip = false ;
    
    /**
     * 管理キューマネージャ.
     */
    protected String queueManagerName = null ;
    
    /**
     * キュー名.
     */
    protected String queueName = null ;
    
    /**
     * オプション.
     */
    protected Serializable option = null ;
    
    /**
     * キュー警告条件.
     */
    protected double warning = QueueDef.DEF_WARNING_PERSENT ;
    
    /**
     * キュー格納最大メッセージ長.
     */
    protected int maxMessageLength = MqDefine.MAX_QUEUE_MESSAGE_LENGTH ;
    
    /**
     * キュー格納最大値.
     */
    protected int maxQueue = QueueDef.DEF_QUEUE_SIZE ;
    
    /**
     * オートコミット.
     */
    protected boolean autoCommit = false ;
    
    /**
     * キャッシュ名.
     */
    protected String cacheName = null ;
    
    /**
     * コンストラクタ.
     */
    public QueueBean() {
        
    }
    
    /**
     * autoCommitを取得.
     * <BR><BR>
     * @return autoCommit が返されます。
     */
    public boolean isAutoCommit() {
        return autoCommit;
    }
    
    /**
     * autoCommitを設定.
     * <BR><BR>
     * @param autoCommit 対象のautoCommitを設定.
     */
    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }
    
    /**
     * gzipを取得.
     * <BR><BR>
     * @return gzip が返されます。
     */
    public boolean isGzip() {
        return gzip;
    }
    
    /**
     * maxMessageLengthを取得.
     * <BR><BR>
     * @return maxMessageLength が返されます。
     */
    public int getMaxMessageLength() {
        return maxMessageLength;
    }
    
    /**
     * maxMessageLengthを設定.
     * <BR><BR>
     * @param maxMessageLength 対象のmaxMessageLengthを設定.
     */
    public void setMaxMessageLength(int maxMessageLength) {
        if( this.maxMessageLength <= maxMessageLength ) {
            this.maxMessageLength = maxMessageLength ;
        }
    }
    
    /**
     * maxQueueを取得.
     * <BR><BR>
     * @return maxQueue が返されます。
     */
    public int getMaxQueue() {
        return maxQueue;
    }
    
    /**
     * maxQueueを設定.
     * <BR><BR>
     * @param maxQueue 対象のmaxQueueを設定.
     */
    public void setMaxQueue(int maxQueue) {
        if( this.maxQueue <= maxQueue ) {
            this.maxQueue = maxQueue;
        }
    }
    
    /**
     * optionを取得.
     * <BR><BR>
     * @return option が返されます。
     */
    public Serializable getOption() {
        return option;
    }
    
    /**
     * queueManagerNameを取得.
     * <BR><BR>
     * @return queueManagerName が返されます。
     */
    public String getQueueManagerName() {
        return queueManagerName;
    }
    
    /**
     * queueNameを取得.
     * <BR><BR>
     * @return queueName が返されます。
     */
    public String getQueueName() {
        return queueName;
    }
    
    /**
     * typeを取得.
     * <BR><BR>
     * @return type が返されます。
     */
    public int getType() {
        return type;
    }
    
    /**
     * warningを取得.
     * <BR><BR>
     * @return warning が返されます。
     */
    public double getWarning() {
        return warning;
    }
    
    /**
     * warningを設定.
     * <BR><BR>
     * @param warning 対象のwarningを設定.
     */
    public void setWarning(double warning) {
        this.warning = warning;
    }
    
    /**
     * cacheNameを取得.
     * <BR><BR>
     * @return cacheName が返されます。
     */
    public String getCacheName() {
        return cacheName;
    }
    
}

