/*
 * @(#)QueueDef.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.queue ;

import org.maachang.queue.access.MaachangQAccessDefine;

/**
 * キュー定義.
 *  
 * @version 2006/09/03
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public class QueueDef {
    
    /**
     * キュータイプ : 受信キュー.
     */
    public static final int TYPE_RECEIVE = MaachangQAccessDefine.TYPE_RECEIVE ;
    
    /**
     * キュータイプ : 送信キュー.
     */
    public static final int TYPE_SEND = MaachangQAccessDefine.TYPE_SEND ;
    
    /**
     * デフォルトキュー格納数.
     */
    public static final int DEF_QUEUE_SIZE = MaachangQAccessDefine.DEFAULT_QUEUE_SIZE ;
    
    /**
     * 最小キュー数.
     */
    public static final int MIN_QUEUE_SIZE = MaachangQAccessDefine.MIN_QUEUE_SIZE ;
    
    /**
     * 最大キュー数.
     */
    public static final int MAX_QUEUE_SIZE = MaachangQAccessDefine.MAX_QUEUE_SIZE ;
    
    /**
     * キュー警告パーセント : デフォルト値.
     */
    public static final double DEF_WARNING_PERSENT = 0.75f ;
    
    /**
     * キュー警告パーセント : 最小値.
     */
    public static final double MIN_WARNING_PERSEND = 0.50f ;
    
    /**
     * キュー警告パーセント : 最大値.
     */
    public static final double MAX_WARNING_PERSEND = 0.95f ;
    
    /**
     * デフォルト優先順位.
     */
    public static final int DEF_PRIORITY = MaachangQAccessDefine.DEFAULT_PRIORITY ;
    
    /**
     * 基本最大プライオリティ.
     */
    public static final int MAX_BASE_PRIORITY = MaachangQAccessDefine.MAX_BASE_PRIORITY ;
    
    /**
     * 最大優先順位.
     */
    public static final int MAX_PRIORITY = MaachangQAccessDefine.MAX_PRIORITY ;
    
    /**
     * 最小優先順位.
     */
    public static final int MIN_PRIORITY = MaachangQAccessDefine.MIN_PRIORITY ;
    
    
    
    /**
     * コンストラクタ.
     */
    private QueueDef() {
        
    }
    
}

