/*
 * @(#)QueueKey.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.queue ;

import java.io.Serializable;

import org.maachang.commons.serialize.SerializeUtil;

/**
 * Key要素情報.
 * <BR><BR>
 * Key要素情報を表すオブジェクト.
 *  
 * @version 2006/09/03
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public abstract class QueueKey implements Serializable {
    
    static {
        serialVersionUID = SerializeUtil.serialVersionUID(
            QueueKey.class.getName()
        ) ;
    }
    
    /**
     * シリアライズUID.
     */
    private static final long serialVersionUID ;
    
    /**
     * キュータイプ.
     */
    private int queueType = -1 ;
    
    /**
     * キュー名.
     */
    private String name = null ;
    
    /**
     * コンストラクタ.
     */
    protected QueueKey() {
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * @param queueType キュータイプを設定します.
     * @param name キュー名を設定します.
     */
    protected QueueKey( int queueType,String name ) {
        this.queueType = queueType ;
        this.name = name ;
    }
    
    /**
     * キュー名を取得.
     * <BR><BR>
     * @return String キュー名が返されます.
     */
    public String getName() {
        return name;
    }
    
    /**
     * キュータイプを取得.
     * <BR><BR>
     * @return int キュータイプが返されます.
     */
    public int getQueueType() {
        return queueType;
    }
    
}

