/*
 * @(#)ReceiveMqInterface.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.queue ;

import org.maachang.queue.access.MaachangQException;


/**
 * 受信MQを表すインターフェイス.
 * <BR><BR>
 * 1つの受信MQを表すインターフェイスです.
 *  
 * @version 2006/12/21
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public interface ReceiveMqInterface {
    
    /**
     * メッセージ情報を取得.
     * <BR><BR>
     * 対象のメッセージ情報を取得します.<BR>
     * また取得できた場合、取得された情報は削除されます.
     * <BR>
     * @param out 取得されたメッセージ情報を格納するオブジェクト.
     * @param transactionId 対象のトランザクションIDを設定します.
     * @param key 対象のキー条件を設定します.<BR>
     *            [null]や[""]を設定した場合、キー条件を無視します.
     * @return boolean 取得結果が返されます.<BR>
     *                  [true]が返された場合、情報取得に成功しました.<BR>
     *                  [false]が返された場合、情報取得に失敗しました.
     * @exception MaachangQException MaachangQ例外.
     */
    public boolean get( QueueValue out,int[] transactionId,String key )
        throws MaachangQException ;
    
    /**
     * メッセージ情報取得後、正常に情報を取得できた場合の処理.
     * <BR><BR>
     * メッセージ情報取得後、正常に情報を取得できた場合の処理します.
     * <BR>
     * @param transactionId 対象のトランザクションIDを設定します.
     * @param value 対象の１つのキューデータ情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public void successGet( int[] transactionId,QueueValue value )
        throws MaachangQException ;
    
}

