/*
 * @(#)SendMqInterface.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.queue ;

import org.maachang.queue.access.MaachangQException;

/**
 * 送信MQを表すインターフェイス.
 * <BR><BR>
 * 1つの送信MQを表すインターフェイスです.
 *  
 * @version 2006/12/21
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public interface SendMqInterface {
    
    /**
     * メッセージ情報を設定.
     * <BR><BR>
     * 対象のメッセージ情報を設定します.
     * <BR>
     * @param transactionId 対象のトランザクションIDを設定します.
     * @param key 対象のキー条件を設定します.<BR>
     *            [null]や[""]を設定した場合、キー条件を無視します.
     * @param processId 対象のプロセスIDを設定します.
     * @param value 対象のメッセージ情報を設定します.
     * @param priority 対象の優先順位を設定します.
     * @param expire 対象の電文寿命を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public void put( int transactionId,String key,String processId,
        byte[] value,int priority,int expire )
        throws MaachangQException ;
    
}

