/*
 * @(#)SendMqOption.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.queue ;

import java.io.Serializable;

import org.maachang.commons.exception.InputException;
import org.maachang.commons.serialize.SerializeUtil;
import org.maachang.commons.util.array.IntArray;
import org.maachang.commons.util.array.ObjectArray;
import org.maachang.queue.main.channel.Channel;
import org.maachang.queue.main.channel.ChannelFactory;

/**
 * 送信MQオプション.
 *  
 * @version 2006/09/05
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public class SendMqOption implements Serializable {
    
    static {
        serialVersionUID = SerializeUtil.serialVersionUID(
            SendMqOption.class.getName()
        ) ;
    }
    
    /**
     * シリアライズUID.
     */
    private static final long serialVersionUID ;
    
    /**
     * 送信チャネル名管理テーブル.
     */
    private ObjectArray table = null ;
    
    /**
     * ID管理テーブル.
     */
    private IntArray idTable = null ;
    
    
    /**
     * コンストラクタ.
     */
    public SendMqOption() {
        table = new ObjectArray() ;
        idTable = new IntArray() ;
    }
    
    /**
     * ファイナライズ処理定義.
     * <BR><BR>
     * ファイナライズ処理定義.
     * @exception Exception 例外処理が返されます.
     */
    protected final void finalize() throws Exception
    {
        table = null ;
        idTable = null ;
    }
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報を全てクリア.
     */
    public void clear() {
        table = new ObjectArray() ;
        idTable = new IntArray() ;
    }
    
    /**
     * 送信チャネルを追加.
     * <BR><BR>
     * この送信キューに対して送信チャネルを追加します.
     * <BR>
     * @param name 追加対象のチャネル名を設定します.
     * @exception InputException 入力例外.
     */
    public synchronized void add( String name )
        throws InputException {
        
        int i ;
        int len ;
        boolean flg = false ;
        
        Channel channel = null ;
        
        if(
            name == null ||
            ( name = name.trim().toLowerCase() ).length() <= 0
        ) {
            throw new InputException( "引数は不正です" ) ;
        }
        
        channel = ChannelFactory.get( Channel.TYPE_SEND,name ) ;
        
        if( channel == null ) {
            throw new InputException( "対象チャネル名[" + name +
                "]は存在しないチャネルです" ) ;
        }
        
        if( ( len = table.size() ) > 0 ) {
            
            for( i = 0 ; i < len ; i ++ ) {
                if( name.equals( table.get( i ) ) == true ) {
                    flg = true ;
                    break ;
                }
            }
            
        }
        
        if( flg == true ) {
            throw new InputException(
                "既にチャネル名[" + name +
                "]はこのキューに存在します" ) ;
        }
        
        table.add( name ) ;
        idTable.add( channel.getId() ) ;
        
    }
    
    /**
     * 送信チャネルを削除.
     * <BR><BR>
     * この送信キューに設定されている送信チャネルを削除します.
     * <BR>
     * @param name 削除対象のチャネル名を設定します.
     * @exception InputException 入力例外.
     */
    public synchronized void remove( String name )
        throws InputException {
        
        int i ;
        int len ;
        
        if(
            name == null ||
            ( name = name.trim().toLowerCase() ).length() <= 0
        ) {
            throw new InputException( "引数は不正です" ) ;
        }
        
        //if( ChannelFactory.get( Channel.TYPE_SEND,name ) == null ) {
        //    throw new InputException( "対象チャネル名[" + name +
        //        "]は存在しないチャネルです" ) ;
        //}
        
        if( ( len = table.size() ) > 0 ) {
            
            for( i = 0 ; i < len ; i ++ ) {
                if( name.equals( table.get( i ) ) == true ) {
                    table.remove( i ) ;
                    idTable.remove( i ) ;
                    break ;
                }
            }
            
        }
        
    }
    
    /**
     * チャネル名を取得.
     * <BR><BR>
     * この送信キューに設定されている送信チャネル名を取得します.
     * <BR>
     * @param no 取得対象の項番を設定します.
     * @return String 対象のチャネル名が返されます.
     */
    public synchronized String get( int no ) {
        
        String ret = null ;
        
        try {
            ret = ( String )table.get( no ) ;
        } catch( Exception e ) {
            ret = null ;
        }
        
        return ret ;
        
    }
    
    /**
     * チャネルIDを取得.
     * <BR><BR>
     * この送信キューに設定されている送信チャネルIDを取得します.
     * <BR>
     * @param no 取得対象の項番を設定します.
     * @return int 対象のチャネルIDが返されます.
     */
    public synchronized int getID( int no ) {
        
        int ret = -1 ;
        
        try {
            ret = idTable.get( no ) ;
        } catch( Exception e ) {
            ret = -1 ;
        }
        
        return ret ;
        
    }
    
    /**
     * チャネルオブジェクトを取得.
     * <BR><BR>
     * この送信キューに設定されている送信チャネルを取得します.
     * <BR>
     * @param no 取得対象の項番を設定します.
     * @return Channel 対象のチャネルオブジェクトが返されます.
     */
    public synchronized Channel getChannel( int no ) {
        
        Channel ret = null ;
        
        try {
            ret = ChannelFactory.get(
                Channel.TYPE_SEND,( String )table.get( no ) ) ;
        } catch( Exception e ) {
            ret = null ;
        }
        
        return ret ;
        
    }
    
    /**
     * チャネル名一覧を取得.
     * <BR><BR>
     * この送信キューに設定されている送信チャネル名一覧が返されます.
     * <BR>
     * @return String[] 送信チャネル名一覧が返されます.
     */
    public synchronized String[] getNames() {
        
        int len ;
        
        String[] ret = null ;
        
        if( ( len = table.size() ) > 0 ) {
            ret = new String[ len ] ;
            System.arraycopy( table.getObjects(),0,ret,0,len ) ;
        }
        
        return ret ;
        
    }
    
    /**
     * チャネルID一覧を取得.
     * <BR><BR>
     * この送信キューに設定されている送信チャネルID一覧が返されます.
     * <BR>
     * @return int[] 送信チャネルID一覧が返されます.
     */
    public synchronized int[] getIds() {
        
        int len ;
        
        int[] ret = null ;
        
        if( ( len = table.size() ) > 0 ) {
            ret = new int[ len ] ;
            System.arraycopy( idTable.getObjects(),0,ret,0,len ) ;
        }
        
        return ret ;
        
    }
    
    /**
     * 設定チャネル数を取得.
     * <BR><BR>
     * 設定されているチャネル数を取得します.
     * <BR>
     * @return int 設定されているチャネル数が返されます.
     */
    public synchronized int size() {
        
        return table.size() ;
        
    }
    
}

