/*
 * @(#)BaseQueueStateImple.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.queue.base ;

import org.maachang.queue.main.queue.QueueState;
import org.maachang.queue.main.queue.base.core.QTable;


/**
 * 基本キューステータス情報.
 * <BR><BR>
 * 基本キューステータスを表すオブジェクト.
 *  
 * @version 2005/12/05
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public interface BaseQueueState extends QueueState {
    
    /**
     * キュー管理オブジェクトを取得.
     * <BR><BR>
     * 設定されているキュー格納オブジェクトを取得します.
     * <BR>
     * @return QTable キュー格納オブジェクトが返されます.
     */
    public QTable getTable() ;
    
    /**
     * 今回ステータスと前回ステータスを交換.
     * <BR><BR>
     * 今回のステータス情報と前回のステータス情報を交換します.
     */
    public void changeState() ;
    
    /**
     * 前回キューステータスを設定.
     * <BR><BR>
     * 対象の前回キューステータスを設定します.
     * <BR>
     * @param state 対象のキューステータスを設定します.
     */
    public void setOldState( int state ) ;
    
    /**
     * 前回キューステータスを取得.
     * <BR><BR>
     * 対象の前回キューステータスを取得します.
     * <BR>
     * @return int 対象の前回キューステータス情報が返されます.<BR>
     *             [STATE_SUCCESS]が返された場合、「正常」です.<BR>
     *             [STATE_DOWN]が返された場合、「停止」です.<BR>
     *             [STATE_STARTUP]が返された場合、「起動中」です.<BR>
     *             [STATE_SHUTDOWN]が返された場合、「停止」です.<BR>
     *             [STATE_ERROR]が返された場合、「異常」です.<BR>
     *             [STATE_WARNING]が返された場合、「キュー格納数指定量による警告」です.<BR>
     *             [STATE_FULL]が返された場合、「キュー満杯」です.
     */
    public int getOldState() ;
    
}

