/*
 * @(#)MonitorExpireThread.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.queue.service ;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.commons.exception.BaseException;
import org.maachang.commons.exception.ExecutionException;
import org.maachang.commons.thread.ExecutionThread;
import org.maachang.commons.thread.LoopThread;
import org.maachang.commons.thread.Synchronized;
import org.maachang.commons.util.UtilCom;
import org.maachang.queue.access.MaachangQAccessDefine;
import org.maachang.queue.main.queue.base.BaseQueue;
import org.maachang.queue.main.queue.base.BaseQueueFactory;
import org.maachang.queue.main.queue.base.core.QArrayChild;

/**
 * Expireキュー情報監視スレッド.
 *  
 * @version 2007/01/25
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
class MonitorExpireThread extends ExecutionThread {
    
    /**
     * 待機時間.
     */
    private static final int WAIT_TIME = 250 ;
    
    /**
     * ログオブジェクト.
     */
    private static final Log LOG = LogFactory.getLog( MonitorExpireThread.class ) ;
    
    /**
     * ループスレッド.
     */
    private final LoopThread thread = new LoopThread() ;
    
    /**
     * 同期処理.
     */
    private final Synchronized sync = new Synchronized() ;
    
    
    /**
     * コンストラクタ.
     */
    public MonitorExpireThread(){
        
        sync.create() ;
        
        try{
            
            thread.create( this ) ;
            thread.startThread() ;
            
        }catch( Exception e ){
            this.destroy() ;
        }
        
    }
    
    /**
     * ファイナライズ処理定義.
     * <BR><BR>
     * ファイナライズ処理定義.
     * <BR>
     * @exception Exception 例外処理が返されます.
     */
    protected final void finalize() throws Exception {
        
        try{
            this.destroy() ;
        }catch( Exception t ){
        }
        
    }
    
    /**
     * オブジェクト破棄.
     * <BR><BR>
     * オブジェクトを破棄します.
     */
    public final void destroy() {
        sync.clear() ;
        thread.clear() ;
    }
    
    /**
     * スレッド状態を取得.
     * <BR><BR>
     * スレッド状態を取得します.
     * <BR>
     * @return boolean スレッド状態が返されます.<BR>
     *                 [true]が返された場合、スレッドは実行中です.<BR>
     *                 [false]が返された場合、スレッドは停止中です.
     */
    public final boolean isThread()
    {
        boolean ret ;
        
        try{
            synchronized( sync.get() ){
                ret = thread.isThread() ;
            }
        }catch( Exception e ){
            ret = false ;
        }
        
        return ret ;
    }
    
    
    
    /**
     * 実行初期化処理をサポートします.
     * <BR><BR>
     * 実行初期化処理をサポートします.<BR>
     * この処理は、スレッド処理が開始された時に呼び出されます.
     * <BR>
     * @param obj 実行開始時に設定されます.
     * @exception ExecutionException 実行例外
     */
    protected final void init( Object obj )
        throws ExecutionException
    {
        
    }
    
    /**
     * 実行終了化処理をサポートします.
     * <BR><BR>
     * 実行終了化処理をサポートします.<BR>
     * この処理は、スレッド処理が終了された時に呼び出されます.
     * <BR>
     * @param obj 実行終了時に設定されます.
     * @exception ExecutionException 実行例外
     */
    protected final void exit( Object obj )
        throws ExecutionException
    {
        
    }
    
    /**
     * ストップ処理をサポートします。
     * <BR><BR>
     * ストップ処理をサポートします。<BR>
     * この処理は、スレッドでのストップ処理に対して呼び出し実行されます.
     * <BR>
     * @param obj ストップ時に設定されます.
     * @exception ExecutionException 実行例外
     */
    protected final void stop( Object obj )
        throws ExecutionException
    {
        
    }
    
    /**
     * 実行処理をサポートします。
     * <BR><BR>
     * 実行処理をサポートします。<BR>
     * この処理は、スレッドでの実行処理に対して呼び出し実行されます.
     * <BR>
     * @param obj 実行時に設定されます.
     * @exception ExecutionException 実行例外
     */
    protected final void execution( Object obj )
        throws ExecutionException {
        
        int type = MaachangQAccessDefine.TYPE_RECEIVE ;
        
        try{
            
            for( int i = 0 ;; i ++ ) {
                
                UtilCom.idleSleep( WAIT_TIME ) ;
                
                BaseQueue queue = BaseQueueFactory.get( type,i ) ;
                
                if( queue == null ) {
                    //if( type == MaachangQAccessDefine.TYPE_RECEIVE ) {
                    //    type = MaachangQAccessDefine.TYPE_SEND ;
                    //    i = -1 ;
                    //    continue ;
                    //}
                    break ;
                }
                else if( queue.isQueue() == false ) {
                    continue ;
                }
                
                for( int j = 0 ;; j ++ ) {
                    
                    UtilCom.idleSleep( WAIT_TIME ) ;
                    
                    if( queue.isQueue() == false ) {
                        break ;
                    }
                    
                    try {
                        //synchronized( queue.getSynchronized().get() ) {
                            
                            QArrayChild ch = queue.getQArrayChild( true,j ) ;
                            
                            if( ch == null ) {
                                break ;
                            }
                            
                            if( queue.executionExpire( ch ) == true ) {
                                //LOG.warn( "------ Expireを検知 ------" ) ;
                                j -- ;
                            }
                        //}
                    } catch( Exception e ) {
                        LOG.error( "キューチェック中にエラー発生",e ) ;
                    }
                    
                }
                
            }
            
        }catch( NullPointerException nul ){
            throw new ExecutionException(
                nul,ExecutionException.LEVEL_STOP
            ) ;
        }catch( BaseException be ){
            LOG.error( "エラーが発生しました", be ) ;
        }catch( Exception e ){
            LOG.error( "エラーが発生しました", e ) ;
        }finally{
            
        }
        
    }
    
}

