/*
 * @(#)QueueService.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.queue.service ;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.commons.sys.NamingManager;
import org.maachang.queue.main.queue.MqManager;

/**
 * キューサービス.
 *  
 * @version 2007/01/25
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public class QueueService {
    
    /**
     * ログオブジェクト.
     */
    private static final Log LOG = LogFactory.getLog( QueueService.class ) ;
    
    /**
     * ネーミングマネージャ登録名.
     */
    public static final String NAMING_MANAGER = "SERVICE@maachangq.main.queue.service" ;
    
    /**
     * 同期オブジェクト.
     */
    private static final Object SYNC = new Object() ;
    
    /**
     * コンストラクタ.
     */
    public QueueService() { }
    
    
    /**
     * 初期化処理.
     * <BR><BR>
     * 初期化処理を行います.
     */
    public void init() {
        
        LOG.info( "#### MaachangQキューサービス生成処理 ####" ) ;
        
        this.destroy( false ) ;
        
        QueueChild child = new QueueChild() ;
        //child.setExpireThread( new MonitorExpireThread() ) ;
        child.setQueueStateThread( new MonitorQueueStateThread() ) ;
        
        // MQマネージャ生成.
        new MqManager().init() ;
        
        // ネーミングマネージャに登録.
        synchronized( SYNC ) {
            
            NamingManager.add( NAMING_MANAGER,child ) ;
            
        }
        
    }
    
    /**
     * 終了化処理.
     * <BR><BR>
     * 終了化処理を行います.
     */
    public void destroy() {
        this.destroy( true ) ;
    }
    
    /**
     * 終了化処理.
     * <BR><BR>
     * 終了化処理を行います.
     * <BR>
     * @param mode ログ表示モードを設定します.
     */
    public void destroy( boolean mode ) {
        
        if( mode == true ) {
            LOG.info( "#### MaachangQキューサービス破棄処理 ####" ) ;
            
            // すべてのキューステータスをシャットダウン中に設定.
            QueueChild ch = ( QueueChild )NamingManager.get(
                NAMING_MANAGER ) ;
            if( ch != null ) {
                try {
                    ch.getQueueStateThread().shutdownQueue() ;
                } catch( Exception e ) {
                }
            }
        }
        
        // ネーミングマネージャから削除.
        synchronized( SYNC ) {
            
            NamingManager.remove( NAMING_MANAGER ) ;
            
        }
        
        // MQマネージャを削除.
        try {
            new MqManager().destroy() ;
        } catch( Exception e ) {
        }
        
    }
}

/**
 * キューサービスチャイルド.
 */
class QueueChild {
    
    private MonitorExpireThread expireThread = null ;
    private MonitorQueueStateThread queueStateThread = null ;
    
    /**
     * expireThreadを取得.
     * <BR><BR>
     * @return expireThread が返されます。
     */
    public MonitorExpireThread getExpireThread() {
        return expireThread;
    }
    /**
     * expireThreadを設定.
     * <BR><BR>
     * @param expireThread 対象のexpireThreadを設定.
     */
    public void setExpireThread(MonitorExpireThread expireThread) {
        this.expireThread = expireThread;
    }
    /**
     * queueStateThreadを取得.
     * <BR><BR>
     * @return queueStateThread が返されます。
     */
    public MonitorQueueStateThread getQueueStateThread() {
        return queueStateThread;
    }
    /**
     * queueStateThreadを設定.
     * <BR><BR>
     * @param queueStateThread 対象のqueueStateThreadを設定.
     */
    public void setQueueStateThread(MonitorQueueStateThread queueStateThread) {
        this.queueStateThread = queueStateThread;
    }
}

