/*
 * @(#)ConnectReceiveMq.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access ;

import org.maachang.queue.access.net.ConnectObject;
import org.maachang.queue.access.net.ReceiveTimeoutException;

/**
 * 受信キューコネクション.
 * <BR><BR>
 * 接続中の受信キューを表すオブジェクト.
 *  
 * @version 2007/01/02
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
class ConnectReceiveMqImple
    extends ConnectSendMqImple
    implements ConnectReceiveMq,ConnectSendMq,ConnectMq {
    
    /**
     * コンストラクタ.
     */
    public ConnectReceiveMqImple() {
        
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * 指定条件を設定してオブジェクトを生成します.
     * <BR>
     * @param MaachangQManager マネージャ管理オブジェクトを設定します.
     * @param connect 対象のコネクションオブジェクトを設定します.
     * @param manager 対象のキューマネージャ名を設定します.
     * @param queue 対象のキュー名を設定します.
     * @param autoCommit 対象のオートコミットモードを設定します.
     */
    public ConnectReceiveMqImple( MaachangQManager maachangQManager,ConnectObject connect,String manager,
        String queue,boolean autoCommit ) {
        super.maachangQManager = maachangQManager ;
        super.connect = connect ;
        super.manager = manager ;
        super.queue = queue ;
        super.autoCommit = autoCommit ;
        super.queueType = MaachangQAccessDefine.TYPE_RECEIVE ;
    }
    
    /**
     * 受信処理.
     * <BR><BR>
     * データ受信処理を行います.
     * <BR>
     * @param value 受信された情報が格納されます.<BR>
     *              また、検索キー情報を設定する場合は、この情報に設定してください.
     * @param timeout 受信タイムアウト値を設定します.<BR>
     *                [0]以下を設定した場合、無限にタイムアウトを待ちます.
     * @exception MaachangQException MaachangQ例外.
     */
    public void receive( MqValue value,int timeout )
        throws MaachangQException {
        
        long tm = 0L ;
        if( timeout > 0L ) {
            tm = System.currentTimeMillis() + timeout ;
        }
        
        if( value == null ) {
            throw new MaachangQException(
                "引数に設定されている受信データ格納条件は不正です" ) ;
        }
        
        value.clearReceive() ;
        
        // 受信データ待ち.
        for( ;; ) {
            try {
                
                // 受信処理.
                ExecutionClientMq.receiveQueue(
                    value,connect,manager,queue,value.getKey() ) ;
                
                // オートコミットでなく、トランザクション開始でない場合.
                if( super.autoCommit == false && super.transactionFlag == false ) {
                    // トランザクションを開始する.
                    super.transactionFlag = true ;
                }
                break ;
                
            } catch( MaachangQException fa ) {
                // 受信データが存在しない場合.
                if( fa.getErrorCode() == MaachangQErrorCode.WARNING_NOT_MESSAGE ) {
                    if( tm > 0L && System.currentTimeMillis() >= tm ) {
                        throw new ReceiveTimeoutException(
                            "タイムアウトが発生しました" ) ;
                    }
                    super.waitTime() ;
                }
                // 上記以外のエラー.
                else {
                    throw fa ;
                }
            }
        }
        
    }
}

