/*
 * @(#)ConnectSendMqImple.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access ;

import org.maachang.queue.access.net.ConnectObject;

/**
 * 送信キューコネクション.
 * <BR><BR>
 * 接続中の送信キューを表すオブジェクト.
 *  
 * @version 2007/01/02
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
class ConnectSendMqImple
    extends ConnectMqImple
    implements ConnectMq,ConnectSendMq {
    
    /**
     * コンストラクタ.
     */
    public ConnectSendMqImple() {
        
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * 指定条件を設定してオブジェクトを生成します.
     * <BR>
     * @param MaachangQManager マネージャ管理オブジェクトを設定します.
     * @param connect 対象のコネクションオブジェクトを設定します.
     * @param manager 対象のキューマネージャ名を設定します.
     * @param queue 対象のキュー名を設定します.
     * @param autoCommit 対象のオートコミットモードを設定します.
     */
    public ConnectSendMqImple( MaachangQManager maachangQManager,ConnectObject connect,String manager,
        String queue,boolean autoCommit ) {
        super.maachangQManager = maachangQManager ;
        super.connect = connect ;
        super.manager = manager ;
        super.queue = queue ;
        super.autoCommit = autoCommit ;
        super.queueType = MaachangQAccessDefine.TYPE_SEND ;
    }
    
    /**
     * データ送信.
     * <BR><BR>
     * データを送信します.
     * <BR>
     * @param value 送信対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public void send( MqValue value )
        throws MaachangQException {
        
        if( value == null ||
            value.getValue() == null ||
            value.getValue().length <= 0 ) {
            throw new MaachangQException( "引数は不正です" ) ;
        }
        
        // トランザクションを確立.
        super.transaction() ;
        
        // 電文送信.
        ExecutionClientMq.sendQueue(
            connect,manager,queue,queueType,
            value.getKey(),value.getProcessId(),
            value.getValue(),value.getExpire(),
            value.getPriority() ) ;
        
    }
    
}

