/*
 * @(#)MaachangQAccessDefine.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access ;


/**
 * MaachangQ-Access定義.
 *  
 * @version 2006/12/26
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public class MaachangQAccessDefine {
    
    private MaachangQAccessDefine(){}
    
    
    
    /////////////////////////////////
    // 基本条件.
    /////////////////////////////////
    
    /**
     * タイプ : 受信キュータイプ.
     */
    public static final int TYPE_RECEIVE = 0x00000000 ;
    
    /**
     * タイプ : 送信キュータイプ.
     */
    public static final int TYPE_SEND = 0x00000001 ;
    
    /**
     * デフォルトタイムアウト.
     */
    //public static final long DEFAULT_TIMEOUT = 300000 ;
    public static final long DEFAULT_TIMEOUT = 30000 ;
    
    /**
     * スーパーユーザ.
     */
    public static final String ROOT_USER = "root" ;
    
    
    
    ////////////////////////////////////
    // MaachangQ - クライアント接続関連.
    ////////////////////////////////////
    
    /**
     * 電文接続ポート.
     */
    public static final int TELEGRAM_PORT = 34501 ;
    
    /**
     * SSL電文接続ポート.
     */
    public static final int SSL_TELEGRAM_PORT = 35501 ;
    
    /**
     * 電文接続ポート最大接続数.
     */
    public static final int DEFAULT_ACCESS_TELEGRAM_PORT = 15 ;
    
    /**
     * 電文接続ポート最大接続数.
     */
    public static final int MAX_ACCESS_TELEGRAM_PORT = 512 ;
    
    /**
     * 管理接続ポート.
     */
    public static final int ADMIN_PORT = 34499 ;
    
    /**
     * SSL管理接続ポート.
     */
    public static final int SSL_ADMIN_PORT = 35499 ;
    
    /**
     * 管理ポート接続最大数.
     */
    public static final int MAX_ACCESS_ADMIN_PORT = 32 ;
    
    
    /////////////////////////////////
    // キャッシュサイズ定義.
    /////////////////////////////////
    
    /**
     * 最大セクター数.
     */
    private static final int MAX_SECTOR = 524288 ;
    
    /**
     * 最小キャッシュセクター数.
     */
    public static final int DEFAULT_CACHE_SECTOR = MAX_SECTOR / 2 ;
    
    /**
     * 最小キャッシュセクター数.
     */
    public static final int MIN_CACHE_SECTOR = MAX_SECTOR / 3 ;
    
    /**
     * 最大キャッシュセクター数.
     */
    public static final int MAX_CACHE_SECTOR = MAX_SECTOR ;
    
    
    /////////////////////////////////
    // キュー情報定義.
    /////////////////////////////////
    
    /**
     * 最大警告パーセント.
     */
    public static final int MAX_WARNING_PARSEND = 95 ;
    
    /**
     * 最小警告パーセント.
     */
    public static final int MIN_WARNING_PARSEND = 50 ;
    
    /**
     * デフォルト警告パーセント.
     */
    public static final int DEFAULT_WARNING_PARSENT = 75 ;
    
    /**
     * 最小キュー数.
     */
    public static final int MIN_QUEUE_SIZE = 999 ;
    
    /**
     * 最大キュー数.
     */
    public static final int MAX_QUEUE_SIZE = 99999 ;
    
    /**
     * デフォルトキュー格納数.
     */
    public static final int DEFAULT_QUEUE_SIZE = 9999 ;
    
    /**
     * デフォルト優先順位.
     */
    public static final int DEFAULT_PRIORITY = 5000 ;
    
    /**
     * 基本最大プライオリティ.
     */
    public static final int MAX_BASE_PRIORITY = 9500 ;
    
    /**
     * 最大優先順位.
     */
    public static final int MAX_PRIORITY = 10000 ;
    
    /**
     * 最小優先順位.
     */
    public static final int MIN_PRIORITY = 0 ;
    
    /**
     * デフォルトチャネル間ポート.
     */
    public static final int DEFAULT_CHANNEL_PORT = 34500 ;
    
}

