/*
 * @(#)MaachangQErrorCode.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access ;

/**
 * MaachangQエラー定義.
 *  
 * @version 2007/01/02
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public class MaachangQErrorCode {
    
    private MaachangQErrorCode(){}
    
    /////////////////////////////////////////////
    // 正常コード.
    /////////////////////////////////////////////
    
    /**
     * 正常終了.
     */
    public static final int SUCCESS = 0 ;
    
    
    /////////////////////////////////////////////
    // エラー種別.
    /////////////////////////////////////////////
    
    /**
     * 警告系.
     */
    public static final int WARNING = 10000000 ;
    
    /**
     * エラー系
     */
    public static final int ERROR = 20000000 ;
    
    /**
     * システム系エラー.
     */
    public static final int SYSTEM_ERROR = 30000000 ;
    
    /**
     * その他エラー.
     */
    public static final int ETC_ERROR = 90000000 ;
    
    
    
    /////////////////////////////////////////////
    // 管理者通信用種別.
    /////////////////////////////////////////////
    
    /**
     * 管理者処理系エラー.
     */
    public static final int ADMIN_ERROR = 8000000 ;
    
    
    
    /////////////////////////////////////////////
    // 処理種別.
    /////////////////////////////////////////////
    
    /**
     * ログイン系エラー.
     */
    public static final int LOGIN_ERROR = 100000 + ADMIN_ERROR ;
    
    /**
     * ユーザ処理系エラー.
     */
    public static final int USER_ERROR = 200000 + ADMIN_ERROR ;
    
    /**
     * キューマネージャ処理系エラー.
     */
    public static final int QUEUE_MANAGER_ERROR = 300000 ;
    
    /**
     * キュー処理系エラー.
     */
    public static final int QUEUE_ERROR = 400000 ;
    
    /**
     * チャネル処理系エラー.
     */
    public static final int CHANNEL_ERROR = 500000 ;
    
    /**
     * コネクション処理系エラー.
     */
    public static final int CONNECT_ERROR = 600000 ;
    
    /**
     * キャッシュ処理系エラー.
     */
    public static final int CACHE_ERROR = 700000 ;
    
    
    
    /////////////////////////////////////////////
    // 特殊エラー.
    /////////////////////////////////////////////
    
    /**
     * その他例外.
     */
    public static final int UNKNOWN_ERROR =
        ETC_ERROR +
        9999999 ;
    
    /**
     * 許可されていないプロトコルタイプを検知.
     */
    public static final int ERROR_NOT_PROTOCOL_TYPE =
        SYSTEM_ERROR +
        1 ;
    
    /**
     * 許可されていない処理タイプを検知.
     */
    public static final int ERROR_NOT_EXECUTION_TYPE =
        SYSTEM_ERROR +
        2 ;
    
    /**
     * プロトコルバージョンは一致しない.
     */
    public static final int ERROR_PROTOCOL_VERSION =
        SYSTEM_ERROR +
        3 ;
    
    /**
     * 処理タイプが不正.
     */
    public static final int ERROR_NOT_TYPE =
        ERROR +
        4 ;
    
    /**
     * 受信タイムアウト.
     */
    public static final int WARNING_TIMEOUT =
        WARNING +
        5 ;
    
    
    
    /////////////////////////////////////////////
    // 通信系エラー.
    /////////////////////////////////////////////
    
    /**
     * 接続先が存在しない.
     */
    public static final int ERROR_CONNECTION =
        SYSTEM_ERROR +
        1 ;
    
    /**
     * 接続数の上限を超した.
     */
    public static final int ERROR_MAX_ACCESS =
        SYSTEM_ERROR +
        2 ;
    
    
    
    /////////////////////////////////////////////
    // ログイン系エラー.
    /////////////////////////////////////////////
    
    /**
     * ログイン処理に失敗.
     */
    public static final int ERROR_LOGIN =
        ERROR +
        LOGIN_ERROR +
        1 ;
    
    /**
     * ログインされていない.
     */
    public static final int ERROR_NO_LOGIN =
        ERROR +
        LOGIN_ERROR +
        2 ;
    
    /**
     * 権限が不足.
     */
    public static final int ERROR_LOGIN_NOT_OWNWE =
        ERROR +
        LOGIN_ERROR +
        3 ;
    
    /**
     * 指定ユーザ名は存在しない.
     */
    public static final int ERROR_NOT_USER =
        ERROR +
        LOGIN_ERROR +
        4 ;
    
    /**
     * 指定ユーザのパスワードは不正.
     */
    public static final int ERROR_NOT_PASSWD =
        ERROR +
        LOGIN_ERROR +
        5 ;
    
    
    
    /////////////////////////////////////////////
    // ユーザ系エラー.
    /////////////////////////////////////////////
    
    /**
     * ユーザ追加に失敗.
     */
    public static final int ERROR_ADD_USER =
        ERROR +
        USER_ERROR +
        101 ;
    
    /**
     * ユーザ削除に失敗.
     */
    public static final int ERROR_REMOVE_USER =
        ERROR +
        USER_ERROR +
        102 ;
    
    /**
     * ユーザパスワード変更に失敗.
     */
    public static final int ERROR_CHANNGE_PASSWD =
        ERROR +
        USER_ERROR +
        103 ;
    
    /**
     * 権限変更に失敗.
     */
    public static final int ERROR_CHANGE_OWNER =
        ERROR +
        USER_ERROR +
        104 ;
    
    /**
     * ユーザ一覧取得に失敗.
     */
    public static final int ERROR_GET_USER_LIST =
        ERROR +
        USER_ERROR +
        105 ;
    
    /**
     * ユーザ数取得に失敗.
     */
    public static final int ERROR_GET_USER_SIZE =
        ERROR +
        USER_ERROR +
        106 ;
    
    /**
     * ログインユーザ数取得に失敗.
     */
    public static final int ERROR_GET_LOGIN_USER_SIZE =
        ERROR +
        USER_ERROR +
        107 ;
    
    /**
     * ユーザ権限取得に失敗.
     */
    public static final int ERROR_GET_USER_OWNER =
        ERROR +
        USER_ERROR +
        108 ;
    
    /**
     * ユーザ存在取得に失敗.
     */
    public static final int ERROR_IS_USER =
        ERROR +
        USER_ERROR +
        109 ;
    
    /**
     * ユーザデータ内容は不正.
     */
    public static final int ERROR_USER =
        ERROR +
        USER_ERROR +
        1 ;
    
    /**
     * 削除対象ユーザは削除できない.
     */
    public static final int ERROR_NOT_DELETE_USER =
        ERROR +
        USER_ERROR +
        2 ;
    
    /**
     * 既に同一ユーザが存在する.
     */
    public static final int ERROR_USE_USER =
        ERROR +
        USER_ERROR +
        3 ;
    
    /**
     * スーパーユーザのみ変更可能.
     */
    public static final int ERROR_EXEC_SUPER_USER =
        ERROR +
        USER_ERROR +
        4 ;
    
    /**
     * パスワードが変更された.
     */
    public static final int WARNING_CHANGE_PASSWD =
        WARNING +
        USER_ERROR +
        5 ;
    
    
    /////////////////////////////////////////////
    // キューマネージャ系エラー.
    /////////////////////////////////////////////
    
    /**
     * キューマネージャの追加に失敗
     */
    public static final int ERROR_ADD_QUEUE_MANAGER =
        ERROR +
        QUEUE_MANAGER_ERROR +
        101 ;
    
    /**
     * キューマネージャの削除に失敗
     */
    public static final int ERROR_REMOVE_QUEUE_MANAGER =
        ERROR +
        QUEUE_MANAGER_ERROR +
        102 ;
    
    /**
     * キューマネージャの停止に失敗
     */
    public static final int ERROR_STOP_QUEUE_MANAGER =
        ERROR +
        QUEUE_MANAGER_ERROR +
        103 ;
    
    /**
     * キューマネージャの開始に失敗
     */
    public static final int ERROR_RESTART_QUEUE_MANAGER =
        ERROR +
        QUEUE_MANAGER_ERROR +
        104 ;
    
    /**
     * キューマネージャの取得に失敗
     */
    public static final int ERROR_GET_QUEUE_MANAGER =
        ERROR +
        QUEUE_MANAGER_ERROR +
        105 ;
    
    /**
     * キューマネージャの一覧取得に失敗
     */
    public static final int ERROR_GET_LIST_QUEUE_MANAGER =
        ERROR +
        QUEUE_MANAGER_ERROR +
        106 ;
    
    /**
     * キューマネージャ数取得に失敗
     */
    public static final int ERROR_GET_SIZE_QUEUE_MANAGER =
        ERROR +
        QUEUE_MANAGER_ERROR +
        107 ;
    
    /**
     * キューマネージャの存在チェックに失敗
     */
    public static final int ERROR_CHECK_QUEUE_MANAGER =
        ERROR +
        QUEUE_MANAGER_ERROR +
        108 ;
    
    /**
     * 対象キューマネージャは存在しない.
     */
    public static final int ERROR_NOT_QUEUE_MANAGER =
        ERROR +
        QUEUE_MANAGER_ERROR +
        1 ;
    
    /**
     * 対象キューマネージャは既に存在している.
     */
    public static final int ERROR_USE_QUEUE_MANAGER =
        ERROR +
        QUEUE_MANAGER_ERROR +
        2 ;
    
    /**
     * 対象キューマネージャは既にクローズしている.
     */
    public static final int ERROR_CLOSE_QUEUE_MANAGER =
        ERROR +
        QUEUE_MANAGER_ERROR +
        3 ;
    
    /**
     * 対象キューマネージャは既に削除されている.
     */
    public static final int ERROR_DELETE_QUEUE_MANAGER =
        ERROR +
        QUEUE_MANAGER_ERROR +
        4 ;
    
    /**
     * 対象キューマネージャステータスは正常ではない.
     */
    public static final int ERROR_QUEUE_MANAGER_NOT_SUCCESS =
        ERROR |
        QUEUE_MANAGER_ERROR |
        5 ;
    
    /**
     * 対象キューマネージャの停止に失敗.
     */
    public static final int ERROR_NOT_STOP_QUEUE_MANAGER =
        ERROR |
        QUEUE_MANAGER_ERROR |
        6 ;
    
    /**
     * 対象キューマネージャ停止から再開に失敗.
     */
    public static final int ERROR_NOT_RESTART_QUEUE_MANAGER =
        ERROR |
        QUEUE_MANAGER_ERROR |
        7 ;
    
    
    /////////////////////////////////////////////
    // キュー系エラー.
    /////////////////////////////////////////////
    
    /**
     * キュー追加に失敗.
     */
    public static final int ERROR_ADD_QUEUE =
        ERROR |
        QUEUE_ERROR |
        101 ;
    
    /**
     * キュー再設定に失敗.
     */
    public static final int ERROR_SET_QUEUE =
        ERROR |
        QUEUE_ERROR |
        102 ;
    
    /**
     * キュー削除に失敗.
     */
    public static final int ERROR_REMOVE_QUEUE =
        ERROR |
        QUEUE_ERROR |
        103 ;
    
    /**
     * キュー取得に失敗.
     */
    public static final int ERROR_GET_QUEUE =
        ERROR |
        QUEUE_ERROR |
        104 ;
    
    /**
     * キュー一覧取得に失敗.
     */
    public static final int ERROR_GET_LIST_QUEUE =
        ERROR |
        QUEUE_ERROR |
        105 ;
    
    /**
     * キュー数取得に失敗.
     */
    public static final int ERROR_GET_SIZE_QUEUE =
        ERROR |
        QUEUE_ERROR |
        107 ;
    
    /**
     * キュー存在確認に失敗.
     */
    public static final int ERROR_IS_QUEUE =
        ERROR |
        QUEUE_ERROR |
        108 ;
    
    /**
     * 対象キューは存在しない.
     */
    public static final int ERROR_NOT_QUEUE =
        ERROR |
        QUEUE_ERROR |
        1 ;
    
    /**
     * 対象キューは既に存在している.
     */
    public static final int ERROR_USE_QUEUE =
        ERROR |
        QUEUE_ERROR |
        2 ;
    
    /**
     * 対象キューは既にクローズしている.
     */
    public static final int ERROR_CLOSE_QUEUE =
        ERROR |
        QUEUE_ERROR |
        3 ;
    
    /**
     * 対象キューは削除されている.
     */
    public static final int ERROR_DELETE_QUEUE =
        ERROR |
        QUEUE_ERROR |
        4 ;
    
    /**
     * 対象キューステータスは正常ではない.
     */
    public static final int ERROR_QUEUE_NOT_SUCCESS =
        ERROR |
        QUEUE_ERROR |
        5 ;
    
    /**
     * 対象キューは他の接続がトランザクションを保持.
     */
    public static final int ERROR_USE_TRANSACTION =
        ERROR |
        QUEUE_ERROR |
        6 ;
    
    /**
     * 対象キューはトランザクションが開始していない.
     */
    public static final int ERROR_NOT_TRANSACTION =
        ERROR |
        QUEUE_ERROR |
        7 ;
    
    /**
     * 対象キューはキューフル状態.
     */
    public static final int ERROR_QUEUE_FULL =
        ERROR |
        QUEUE_ERROR |
        8 ;
    
    /**
     * 送信データはメッセージ長オーバー.
     */
    public static final int ERROR_QUEUE_MESSAGE_OVER =
        ERROR |
        QUEUE_ERROR |
        9 ;
    
    /**
     * 指定キュータイプは不正.
     */
    public static final int ERROR_QUEUE_TYPE =
        ERROR |
        QUEUE_ERROR |
        10 ;
    
    /**
     * 対象キューに電文は存在しない.
     */
    public static final int WARNING_NOT_MESSAGE =
        WARNING |
        QUEUE_ERROR |
        11 ;
    
    
    /////////////////////////////////////////////
    // チャネル系エラー.
    /////////////////////////////////////////////
    
    /**
     * チャネル追加に失敗.
     */
    public static final int ERROR_ADD_CHANNEL =
        ERROR |
        CHANNEL_ERROR |
        101 ;
    
    /**
     * チャネル設定に失敗.
     */
    public static final int ERROR_SET_CHANNEL =
        ERROR |
        CHANNEL_ERROR |
        102 ;
    
    /**
     * チャネル削除に失敗.
     */
    public static final int ERROR_REMOVE_CHANNEL =
        ERROR |
        CHANNEL_ERROR |
        103 ;
    
    /**
     * チャネル停止に失敗.
     */
    public static final int ERROR_STOP_CHANNEL =
        ERROR |
        CHANNEL_ERROR |
        104 ;
    
    /**
     * チャネル再開に失敗.
     */
    public static final int ERROR_RESTART_CHANNEL =
        ERROR |
        CHANNEL_ERROR |
        105 ;
    
    /**
     * チャネル取得に失敗.
     */
    public static final int ERROR_GET_CHANNEL =
        ERROR |
        CHANNEL_ERROR |
        106 ;
    
    /**
     * チャネル一覧取得に失敗.
     */
    public static final int ERROR_GET_LIST_CHANNEL =
        ERROR |
        CHANNEL_ERROR |
        107 ;
    
    /**
     * チャネル数取得に失敗.
     */
    public static final int ERROR_GET_SIZE_CHANNEL =
        ERROR |
        CHANNEL_ERROR |
        108 ;
    
    /**
     * チャネル存在取得に失敗.
     */
    public static final int ERROR_IS_CHANNEL =
        ERROR |
        CHANNEL_ERROR |
        109 ;
    
    /**
     * 対象チャネルは存在しない.
     */
    public static final int ERROR_NOT_CHANNEL =
        ERROR |
        CHANNEL_ERROR |
        1 ;
    
    /**
     * 対象チャネルは既に存在する.
     */
    public static final int ERROR_USE_CHANNEL =
        ERROR |
        CHANNEL_ERROR |
        2 ;
    
    /**
     * 対象チャネルの停止に失敗.
     */
    public static final int ERROR_NOT_STOP_CHANNEL =
        ERROR |
        CHANNEL_ERROR |
        3 ;
    
    /**
     * 対象チャネルの再開に失敗.
     */
    public static final int ERROR_NOT_RESTART_CHANNEL =
        ERROR |
        CHANNEL_ERROR |
        4 ;
    
    
    /////////////////////////////////////////////
    // コネクション系エラー.
    /////////////////////////////////////////////
    
    /**
     * コネクション追加に失敗.
     */
    public static final int ERROR_ADD_CONNECT =
        ERROR |
        CONNECT_ERROR |
        101 ;
    
    /**
     * コネクション設定に失敗.
     */
    public static final int ERROR_SET_CONNECT =
        ERROR |
        CONNECT_ERROR |
        102 ;
    
    /**
     * コネクション削除に失敗.
     */
    public static final int ERROR_REMOVE_CONNECT =
        ERROR |
        CONNECT_ERROR |
        103 ;
    
    /**
     * コネクション取得に失敗.
     */
    public static final int ERROR_GET_CONNECT =
        ERROR |
        CONNECT_ERROR |
        104 ;
    
    /**
     * コネクション一覧取得に失敗.
     */
    public static final int ERROR_GET_LIST_CONNECT =
        ERROR |
        CONNECT_ERROR |
        105 ;
    
    /**
     * コネクション数取得に失敗.
     */
    public static final int ERROR_GET_SIZE_CONNECT =
        ERROR |
        CONNECT_ERROR |
        106 ;
    
    /**
     * コネクション存在確認に失敗.
     */
    public static final int ERROR_IS_CONNECT =
        ERROR |
        CONNECT_ERROR |
        107 ;
    
    /**
     * 対象コネクションは存在しない.
     */
    public static final int ERROR_NOT_CONNECT =
        ERROR |
        CONNECT_ERROR |
        1 ;
    
    /**
     * 対象コネクションは既に存在する.
     */
    public static final int ERROR_USE_CONNECT =
        ERROR |
        CONNECT_ERROR |
        2 ;
    
    /**
     * 指定キャッシュ名は存在しない.
     */
    public static final int ERROR_NOT_SET_CACHE_CONNECT =
        ERROR |
        CONNECT_ERROR |
        3 ;
    
    /**
     * 指定バインド条件は既に存在する.
     */
    public static final int ERROR_USE_BIND_CONNECT =
        ERROR |
        CONNECT_ERROR |
        4 ;
    
    
    /////////////////////////////////////////////
    // キャッシュ系エラー.
    /////////////////////////////////////////////
    
    /**
     * キャッシュ追加に失敗.
     */
    public static final int ERROR_ADD_CACHE =
        ERROR |
        CACHE_ERROR |
        101 ;
    
    /**
     * キャッシュ削除に失敗.
     */
    public static final int ERROR_REMOVE_CACHE =
        ERROR |
        CACHE_ERROR |
        102 ;
    
    /**
     * キャッシュ取得に失敗.
     */
    public static final int ERROR_GET_CACHE =
        ERROR |
        CACHE_ERROR |
        103 ;
    
    /**
     * キャッシュ名一覧取得に失敗.
     */
    public static final int ERROR_GET_LIST_CACHE =
        ERROR |
        CACHE_ERROR |
        104 ;
    
    /**
     * キャッシュ数取得に失敗.
     */
    public static final int ERROR_GET_SIZE_CACHE =
        ERROR |
        CACHE_ERROR |
        105 ;
    
    /**
     * キャッシュ存在確認に失敗.
     */
    public static final int ERROR_IS_CACHE =
        ERROR |
        CACHE_ERROR |
        106 ;
    
    /**
     * 対象キャッシュは存在しない.
     */
    public static final int ERROR_NOT_CACHE =
        ERROR |
        CACHE_ERROR |
        1 ;
    
    /**
     * 対象キャッシュは既に存在する.
     */
    public static final int ERROR_USE_CACHE =
        ERROR |
        CACHE_ERROR |
        2 ;
    
    
    
}

