/*
 * @(#)MaachangQException.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access ;

/**
 * MaachangQ例外.
 *  
 * @version 2007/01/02
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public class MaachangQException extends Exception {
    
    /**
     * シリアライズID.
     */
    private static final long serialVersionUID = -4282754092282804093L;
    
    /**
     * エラーコード.
     */
    protected int errorCode = MaachangQErrorCode.UNKNOWN_ERROR ;
    
    /**
     * コンタストラクタ.
     */
    private MaachangQException() {
        super() ;
        this.errorCode = MaachangQErrorCode.UNKNOWN_ERROR ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します.
     * @param errorCode エラーコードを設定します.
     */
    public MaachangQException( Throwable e ) {
        super(e) ;
        if( e instanceof MaachangQException ) {
            this.errorCode = ( ( MaachangQException )e ).errorCode ;
        }
        else {
            this.errorCode = MaachangQErrorCode.UNKNOWN_ERROR ;
        }
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します.
     * @param errorCode エラーコードを設定します.
     */
    public MaachangQException( Throwable e,int errorCode ) {
        super(e) ;
        this.errorCode = errorCode ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時にメッセージを設定します.
     * <BR>
     * @param message スローエラー生成時のメッセージを設定します.
     * @param errorCode エラーコードを設定します.
     */
    public MaachangQException( String message ) {
        super(message) ;
        this.errorCode = MaachangQErrorCode.UNKNOWN_ERROR ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時にメッセージを設定します.
     * <BR>
     * @param message スローエラー生成時のメッセージを設定します.
     * @param errorCode エラーコードを設定します.
     */
    public MaachangQException( String message,int errorCode ) {
        super(message) ;
        this.errorCode = errorCode ;
    }
    
    /**
     * エラーコードを設定.
     * <BR><BR>
     * エラーコードを設定します.
     * <BR>
     * @param errorCode 対象のエラーコードを設定します.
     */
    public void setErrorCode( int errorCode ) {
        this.errorCode = errorCode ;
    }
    
    /**
     * エラーコードを取得.
     * <BR><BR>
     * エラーコードを取得します.
     * <BR>
     * @return int エラーコードが返されます.
     */
    public int getErrorCode() {
        return this.errorCode ;
    }
    
}
