/*
 * @(#)MaachangQManager.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access ;

import java.net.InetAddress;

/**
 * キューマネージャ接続.
 * <BR><BR>
 * 接続中のキューマネージャを表すインターフェイス.
 *  
 * @version 2007/01/02
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public interface MaachangQManager {
    
    /**
     * MQマネージャクローズ.
     * <BR><BR>
     * 接続中のMQマネージャをクローズします.
     */
    public void close() ;
    
    /**
     * コミット処理.
     * <BR><BR>
     * コミット処理を行います.
     * <BR>
     * @exception MaachangQException MaachangQ例外.
     */
    public void commit() throws MaachangQException ;
    
    /**
     * ロールバック処理.
     * <BR><BR>
     * ロールバック処理を行います.
     * <BR>
     * @exception MaachangQException MaachangQ例外.
     */
    public void rollback() throws MaachangQException ;
    
    /**
     * 対象送信キューにコネクション.
     * <BR><BR>
     * オープン中のキューマネージャ内の送信キューに接続します.
     * <BR>
     * @param name コネクション対象のキュー名を設定します.
     * @return ConnectMq 接続された送信Mqオブジェクトが返されます.
     * @exception MaachangQException MaachangQ例外.
     */
    public ConnectSendMq connectSendQueue( String name )
        throws MaachangQException ;
    
    /**
     * 対象受信キューにコネクション.
     * <BR><BR>
     * オープン中のキューマネージャ内の受信キューに接続します.
     * <BR>
     * @param name コネクション対象の受信キュー名を設定します.
     * @return ConnectMq 接続された受信Mqオブジェクトが返されます.
     * @exception MaachangQException MaachangQ例外.
     */
    public ConnectReceiveMq connectReceiveQueue( String name )
        throws MaachangQException ;
    
    /**
     * 対象キューマネージャ名を取得.
     * <BR><BR>
     * 接続中のキューマネージャ名を取得します.
     * <BR>
     * @return String 対象キューマネージャ名が返されます.
     */
    public String getManagerName() ;
    
    /**
     * 接続先アドレスを取得.
     * <BR><BR>
     * 接続先のアドレスを取得します.
     * <BR>
     * @return InetAddress 接続先アドレスが返されます.
     */
    public InetAddress getInetAddress() ;
    
    /**
     * 接続先ポート番号を取得.
     * <BR><BR>
     * 接続先ポート番号を取得します.
     * <BR>
     * @return int 接続先ポート番号が返されます.
     */
    public int getPort() ;
    
    /**
     * 通信状態を取得.
     * <BR><BR>
     * 通信状態を取得します.<BR>
     * この情報は１秒あたりの受信バイト値を表す情報です.
     * <BR>
     * @return long １秒あたりの受信バイト値が返されます.
     */
    public long getSecondToByte() ;
    
    /**
     * キューマネージャがオープン中かチェック.
     * <BR><RB>
     * 対象のキューマネージャがオープン中であるかチェックします.
     * <BR>
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]が返された場合、オープン中です.<BR>
     *                 [false]が返された場合、クローズしています.
     */
    public boolean isOpen() ;
    
}

