/*
 * @(#)MqValue.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access ;

/**
 * MQデータ.
 * <BR><BR>
 * 送受信で利用するMQデータを表すオブジェクト.
 *  
 * @version 2007/01/15
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public class MqValue {
    
    /**
     * 文字列変換キャラクタセット.
     */
    public static final String STRING_VALUE = "UTF8" ;
    
    /**
     * Key情報.
     */
    private String key = null ;
    
    /**
     * プロセスID.
     */
    private String processId = null ;
    
    /**
     * 電文データ.
     */
    private byte[] value = null ;
    
    /**
     * 優先順位.
     */
    private int priority = MaachangQAccessDefine.DEFAULT_PRIORITY ;
    
    /**
     * 電文寿命.
     */
    private int expire = -1 ;
    
    /**
     * コンストラクタ.
     */
    public MqValue() {
        
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * @param value 対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public MqValue( byte[] value )
        throws MaachangQException {
        this.create( value ) ;
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * @param expire Expire値を設定します.<BR>
     *               この情報は、電文受信までに、この時間が経過した場合、
     *               その情報は受け取らないようにするためのものです.
     * @param value 対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public MqValue( int expire,byte[] value )
        throws MaachangQException {
        this.create( expire,value ) ;
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * @param expire Expire値を設定します.<BR>
     *               この情報は、電文受信までに、この時間が経過した場合、
     *               その情報は受け取らないようにするためのものです.
     * @param priority 対象の優先順位を設定します.<BR>
     *                 設定できる最小値は[0]です.<BR>
     *                 設定できる最大値は[9500]です.
     * @param value 対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public MqValue( int expire,int priority,byte[] value )
        throws MaachangQException {
        this.create( expire,priority,value ) ;
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * @param expire Expire値を設定します.<BR>
     *               この情報は、電文受信までに、この時間が経過した場合、
     *               その情報は受け取らないようにするためのものです.
     * @param priority 対象の優先順位を設定します.<BR>
     *                 設定できる最小値は[0]です.<BR>
     *                 設定できる最大値は[9500]です.
     * @param processId 対象のプロセスIDを設定します.
     * @param value 対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public MqValue( int expire,int priority,String processId,byte[] value )
        throws MaachangQException {
        this.create( expire,priority,processId,value ) ;
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * @param key キー情報を設定します.
     * @param value 対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public MqValue( String key,byte[] value )
        throws MaachangQException {
        this.create( key,value ) ;
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * @param key キー情報を設定します.
     * @param expire Expire値を設定します.<BR>
     *               この情報は、電文受信までに、この時間が経過した場合、
     *               その情報は受け取らないようにするためのものです.
     * @param value 対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public MqValue( String key,int expire,byte[] value )
        throws MaachangQException {
        this.create( key,expire,value ) ;
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * @param key キー情報を設定します.
     * @param expire Expire値を設定します.<BR>
     *               この情報は、電文受信までに、この時間が経過した場合、
     *               その情報は受け取らないようにするためのものです.
     * @param priority 対象の優先順位を設定します.<BR>
     *                 設定できる最小値は[0]です.<BR>
     *                 設定できる最大値は[9500]です.
     * @param value 対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public MqValue( String key,int expire,int priority,byte[] value )
        throws MaachangQException {
        this.create( key,expire,priority,value ) ;
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * @param key キー情報を設定します.
     * @param expire Expire値を設定します.<BR>
     *               この情報は、電文受信までに、この時間が経過した場合、
     *               その情報は受け取らないようにするためのものです.
     * @param priority 対象の優先順位を設定します.<BR>
     *                 設定できる最小値は[0]です.<BR>
     *                 設定できる最大値は[9500]です.
     * @param processId 対象のプロセスIDを設定します.
     * @param value 対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public MqValue( String key,int expire,int priority,String processId,byte[] value )
        throws MaachangQException {
        this.create( key,expire,priority,processId,value ) ;
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * @param value 対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public MqValue( String value )
        throws MaachangQException {
        this.create( value ) ;
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * @param expire Expire値を設定します.<BR>
     *               この情報は、電文受信までに、この時間が経過した場合、
     *               その情報は受け取らないようにするためのものです.
     * @param value 対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public MqValue( int expire,String value )
        throws MaachangQException {
        this.create( expire,value ) ;
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * @param expire Expire値を設定します.<BR>
     *               この情報は、電文受信までに、この時間が経過した場合、
     *               その情報は受け取らないようにするためのものです.
     * @param priority 対象の優先順位を設定します.<BR>
     *                 設定できる最小値は[0]です.<BR>
     *                 設定できる最大値は[9500]です.
     * @param value 対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public MqValue( int expire,int priority,String value )
        throws MaachangQException {
        this.create( expire,priority,value ) ;
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * @param expire Expire値を設定します.<BR>
     *               この情報は、電文受信までに、この時間が経過した場合、
     *               その情報は受け取らないようにするためのものです.
     * @param priority 対象の優先順位を設定します.<BR>
     *                 設定できる最小値は[0]です.<BR>
     *                 設定できる最大値は[9500]です.
     * @param processId 対象のプロセスIDを設定します.
     * @param value 対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public MqValue( int expire,int priority,String processId,String value )
        throws MaachangQException {
        this.create( expire,priority,processId,value ) ;
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * @param key キー情報を設定します.
     * @param value 対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public MqValue( String key,String value )
        throws MaachangQException {
        this.create( key,value ) ;
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * @param key キー情報を設定します.
     * @param expire Expire値を設定します.<BR>
     *               この情報は、電文受信までに、この時間が経過した場合、
     *               その情報は受け取らないようにするためのものです.
     * @param value 対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public MqValue( String key,int expire,String value )
        throws MaachangQException {
        this.create( key,expire,value ) ;
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * @param key キー情報を設定します.
     * @param expire Expire値を設定します.<BR>
     *               この情報は、電文受信までに、この時間が経過した場合、
     *               その情報は受け取らないようにするためのものです.
     * @param priority 対象の優先順位を設定します.<BR>
     *                 設定できる最小値は[0]です.<BR>
     *                 設定できる最大値は[9500]です.
     * @param value 対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public MqValue( String key,int expire,int priority,String value )
        throws MaachangQException {
        this.create( key,expire,priority,value ) ;
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * @param key キー情報を設定します.
     * @param expire Expire値を設定します.<BR>
     *               この情報は、電文受信までに、この時間が経過した場合、
     *               その情報は受け取らないようにするためのものです.
     * @param priority 対象の優先順位を設定します.<BR>
     *                 設定できる最小値は[0]です.<BR>
     *                 設定できる最大値は[9500]です.
     * @param processId 対象のプロセスIDを設定します.
     * @param value 対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public MqValue( String key,int expire,int priority,String processId,String value )
        throws MaachangQException {
        this.create( key,expire,priority,processId,value ) ;
    }
    
    /**
     * 情報生成.
     * <BR><BR>
     * @param value 対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public void create( byte[] value )
        throws MaachangQException {
        this.create( null,-1,MaachangQAccessDefine.DEFAULT_PRIORITY,null,value ) ;
    }
    
    /**
     * 情報生成.
     * <BR><BR>
     * @param expire Expire値を設定します.<BR>
     *               この情報は、電文受信までに、この時間が経過した場合、
     *               その情報は受け取らないようにするためのものです.
     * @param value 対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public void create( int expire,byte[] value )
        throws MaachangQException {
        this.create( null,expire,MaachangQAccessDefine.DEFAULT_PRIORITY,null,value ) ;
    }
    
    /**
     * 情報生成.
     * <BR><BR>
     * @param expire Expire値を設定します.<BR>
     *               この情報は、電文受信までに、この時間が経過した場合、
     *               その情報は受け取らないようにするためのものです.
     * @param priority 対象の優先順位を設定します.<BR>
     *                 設定できる最小値は[0]です.<BR>
     *                 設定できる最大値は[9500]です.
     * @param value 対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public void create( int expire,int priority,byte[] value )
        throws MaachangQException {
        this.create( null,expire,priority,null,value ) ;
    }
    
    /**
     * 情報生成.
     * <BR><BR>
     * @param expire Expire値を設定します.<BR>
     *               この情報は、電文受信までに、この時間が経過した場合、
     *               その情報は受け取らないようにするためのものです.
     * @param priority 対象の優先順位を設定します.<BR>
     *                 設定できる最小値は[0]です.<BR>
     *                 設定できる最大値は[9500]です.
     * @param processId 対象のプロセスIDを設定します.
     * @param value 対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public void create( int expire,int priority,String processId,byte[] value )
        throws MaachangQException {
        this.create( null,expire,priority,processId,value ) ;
    }
    
    /**
     * 情報生成.
     * <BR><BR>
     * @param key キー情報を設定します.
     * @param value 対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public void create( String key,byte[] value )
        throws MaachangQException {
        this.create( key,-1,MaachangQAccessDefine.DEFAULT_PRIORITY,null,value ) ;
    }
    
    /**
     * 情報生成.
     * <BR><BR>
     * @param key キー情報を設定します.
     * @param expire Expire値を設定します.<BR>
     *               この情報は、電文受信までに、この時間が経過した場合、
     *               その情報は受け取らないようにするためのものです.
     * @param value 対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public void create( String key,int expire,byte[] value )
        throws MaachangQException {
        this.create( key,expire,MaachangQAccessDefine.DEFAULT_PRIORITY,null,value ) ;
    }
    
    /**
     * 情報生成.
     * <BR><BR>
     * @param key キー情報を設定します.
     * @param expire Expire値を設定します.<BR>
     *               この情報は、電文受信までに、この時間が経過した場合、
     *               その情報は受け取らないようにするためのものです.
     * @param priority 対象の優先順位を設定します.<BR>
     *                 設定できる最小値は[0]です.<BR>
     *                 設定できる最大値は[9500]です.
     * @param value 対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public void create( String key,int expire,int priority,byte[] value )
        throws MaachangQException {
        this.create( key,expire,priority,null,value ) ;
    }
    
    /**
     * 情報生成.
     * <BR><BR>
     * @param key キー情報を設定します.
     * @param expire Expire値を設定します.<BR>
     *               この情報は、電文受信までに、この時間が経過した場合、
     *               その情報は受け取らないようにするためのものです.
     * @param priority 対象の優先順位を設定します.<BR>
     *                 設定できる最小値は[0]です.<BR>
     *                 設定できる最大値は[9500]です.
     * @param processId 対象のプロセスIDを設定します.
     * @param value 対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public void create( String key,int expire,int priority,String processId,byte[] value )
        throws MaachangQException {
        
        if( value == null || value.length <= 0 ) {
            throw new MaachangQException( "電文情報は設定されていません",
                MaachangQErrorCode.UNKNOWN_ERROR ) ;
        }
        
        this.setKey( key ) ;
        this.setExpire( expire ) ;
        this.setPriority( priority ) ;
        this.setProcessId( processId ) ;
        this.setValue( value ) ;
        
    }
    
    /**
     * 情報生成.
     * <BR><BR>
     * @param value 対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public void create( String value )
        throws MaachangQException {
        this.create( null,-1,MaachangQAccessDefine.DEFAULT_PRIORITY,null,value ) ;
    }
    
    /**
     * 情報生成.
     * <BR><BR>
     * @param expire Expire値を設定します.<BR>
     *               この情報は、電文受信までに、この時間が経過した場合、
     *               その情報は受け取らないようにするためのものです.
     * @param value 対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public void create( int expire,String value )
        throws MaachangQException {
        this.create( null,expire,MaachangQAccessDefine.DEFAULT_PRIORITY,null,value ) ;
    }
    
    /**
     * 情報生成.
     * <BR><BR>
     * @param expire Expire値を設定します.<BR>
     *               この情報は、電文受信までに、この時間が経過した場合、
     *               その情報は受け取らないようにするためのものです.
     * @param priority 対象の優先順位を設定します.<BR>
     *                 設定できる最小値は[0]です.<BR>
     *                 設定できる最大値は[9500]です.
     * @param value 対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public void create( int expire,int priority,String value )
        throws MaachangQException {
        this.create( null,expire,priority,null,value ) ;
    }
    
    /**
     * 情報生成.
     * <BR><BR>
     * @param expire Expire値を設定します.<BR>
     *               この情報は、電文受信までに、この時間が経過した場合、
     *               その情報は受け取らないようにするためのものです.
     * @param priority 対象の優先順位を設定します.<BR>
     *                 設定できる最小値は[0]です.<BR>
     *                 設定できる最大値は[9500]です.
     * @param processId 対象のプロセスIDを設定します.
     * @param value 対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public void create( int expire,int priority,String processId,String value )
        throws MaachangQException {
        this.create( null,expire,priority,processId,value ) ;
    }
    
    /**
     * 情報生成.
     * <BR><BR>
     * @param key キー情報を設定します.
     * @param value 対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public void create( String key,String value )
        throws MaachangQException {
        this.create( key,-1,MaachangQAccessDefine.DEFAULT_PRIORITY,null,value ) ;
    }
    
    /**
     * 情報生成.
     * <BR><BR>
     * @param key キー情報を設定します.
     * @param expire Expire値を設定します.<BR>
     *               この情報は、電文受信までに、この時間が経過した場合、
     *               その情報は受け取らないようにするためのものです.
     * @param value 対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public void create( String key,int expire,String value )
        throws MaachangQException {
        this.create( key,expire,MaachangQAccessDefine.DEFAULT_PRIORITY,null,value ) ;
    }
    
    /**
     * 情報生成.
     * <BR><BR>
     * @param key キー情報を設定します.
     * @param expire Expire値を設定します.<BR>
     *               この情報は、電文受信までに、この時間が経過した場合、
     *               その情報は受け取らないようにするためのものです.
     * @param priority 対象の優先順位を設定します.<BR>
     *                 設定できる最小値は[0]です.<BR>
     *                 設定できる最大値は[9500]です.
     * @param value 対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public void create( String key,int expire,int priority,String value )
        throws MaachangQException {
        this.create( key,expire,priority,null,value ) ;
    }
    
    /**
     * 情報生成.
     * <BR><BR>
     * @param key キー情報を設定します.
     * @param expire Expire値を設定します.<BR>
     *               この情報は、電文受信までに、この時間が経過した場合、
     *               その情報は受け取らないようにするためのものです.
     * @param priority 対象の優先順位を設定します.<BR>
     *                 設定できる最小値は[0]です.<BR>
     *                 設定できる最大値は[9500]です.
     * @param processId 対象のプロセスIDを設定します.
     * @param value 対象の情報を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public void create( String key,int expire,int priority,String processId,String value )
        throws MaachangQException {
        if( value == null || value.length() <= 0 ) {
            throw new MaachangQException( "電文情報は設定されていません",
                MaachangQErrorCode.UNKNOWN_ERROR ) ;
        }
        
        this.setKey( key ) ;
        this.setExpire( expire ) ;
        this.setPriority( priority ) ;
        this.setProcessId( processId ) ;
        this.setStringValue( value ) ;
        
    }
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報をクリアします.
     */
    public void clear() {
        key = null ;
        processId = null ;
        value = null ;
        priority = MaachangQAccessDefine.DEFAULT_PRIORITY ;
        expire = -1 ;
    }
    
    /**
     * 受信条件用クリア.
     * <BR><BR>
     * 受信条件用クリア処理.
     */
    protected void clearReceive() {
        processId = null ;
        value = null ;
        priority = MaachangQAccessDefine.DEFAULT_PRIORITY ;
        expire = -1 ;
    }
    
    /**
     * 文字列をvalue として設定.
     * <BR><BR>
     * @param stringValue 対象の文字列を設定します.
     */
    public void setStringValue(String stringValue) {
        if( stringValue == null || stringValue.length() <= 0 ) {
            return ;
        }
        try {
            this.setValue( stringValue.getBytes( STRING_VALUE ) ) ;
        } catch( Exception e ) {
        }
    }
    
    /**
     * value を文字列として取得.
     * <BR><BR>
     * @return String 対象の文字列が返されます.
     */
    public String getStringValue() {
        
        if( this.value == null || this.value.length <= 0 ) {
            return null ;
        }
        
        String ret = null ;
        
        try {
            ret = new String( this.value,STRING_VALUE ) ;
        } catch( Exception e ) {
            ret = null ;
        }
        
        return ret ;
    }
    
    /**
     * value を取得.
     * <BR><BR>
     * @return value が返されます.
     */
    public byte[] getValue() {
        return value;
    }
    
    /**
     * value を設定.
     * <BR><BR>
     * @param value value を設定します.
     */
    public void setValue(byte[] value) {
        if( value == null || value.length <= 0 ) {
            return ;
        }
        this.value = value;
    }
    
    /**
     * expire を取得.
     * <BR><BR>
     * @return expire が返されます.
     */
    public int getExpire() {
        return expire;
    }
    
    /**
     * expire を設定.
     * <BR><BR>
     * @param expire expire を設定します.
     */
    public void setExpire(int expire) {
        if( expire <= -1 ) {
            expire = -1 ;
        }
        this.expire = expire;
    }
    
    /**
     * key を取得.
     * <BR><BR>
     * @return key が返されます.
     */
    public String getKey() {
        return key;
    }
    
    /**
     * key を設定.
     * <BR><BR>
     * @param key key を設定します.
     */
    public void setKey(String key) {
        if( key == null || ( key = key.trim() ).length() <= 0 ) {
            key = null ;
        }
        this.key = key;
    }
    
    /**
     * priority を取得.
     * <BR><BR>
     * @return priority が返されます.
     */
    public int getPriority() {
        return priority;
    }
    
    /**
     * priority を設定.
     * <BR><BR>
     * @param priority priority を設定します.
     */
    public void setPriority(int priority) {
        if( priority <= MaachangQAccessDefine.MIN_PRIORITY ) {
            priority = MaachangQAccessDefine.MIN_PRIORITY ;
        }
        else if( priority >= MaachangQAccessDefine.MAX_BASE_PRIORITY ) {
            priority = MaachangQAccessDefine.MAX_BASE_PRIORITY ;
        }
        this.priority = priority;
    }
    
    /**
     * processId を取得.
     * <BR><BR>
     * @return processId が返されます.
     */
    public String getProcessId() {
        return processId;
    }
    
    /**
     * processId を設定.
     * <BR><BR>
     * @param processId processId を設定します.
     */
    public void setProcessId(String processId) {
        if( processId == null ||
            ( processId = processId.trim() ).length() <= 0 ) {
            processId = null ;
        }
        this.processId = processId;
    }
}

