/*
 * @(#)AdminUser.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.admin ;

import org.maachang.queue.access.MaachangQException;
import org.maachang.queue.access.admin.info.CreateUserInfo;
import org.maachang.queue.access.admin.info.UserInfo;


/**
 * ユーザ管理情報.
 * <BR><BR>
 * ユーザ管理情報を表すインターフェイス.
 *  
 * @version 2007/01/02
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public interface AdminUser {
    
    /**
     * 新しいユーザを追加.
     * <BR><BR>
     * 新しいユーザを追加します.<BR>
     * このメソッドは、管理者権限を持たない場合、処理できません.
     * <BR>
     * @param info ユーザ情報を設定します.
     * @param passwd パスワードを設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public void addUser( CreateUserInfo info,String passwd )
        throws MaachangQException ;
    
    /**
     * 対象ユーザを削除.
     * <BR><BR>
     * 対象のユーザを削除します.<BR>
     * このメソッドは、管理者権限を持たない場合、処理できません.
     * <BR>
     * @param user 削除対象のユーザ名を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public void removeUser( String user )
        throws MaachangQException ;
    
    /**
     * 指定ユーザパスワードを変更.
     * <BR><BR>
     * 指定ユーザのパスワードを変更します.<BR>
     * このメソッドは、管理者権限を持たない場合、処理できません.
     * <BR>
     * @param user パスワード変更ユーザを設定します.
     * @param newPasswd 新しいパスワードを設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public void changePasswd( String user,String newPasswd )
        throws MaachangQException ;
    
    /**
     * 現在ユーザパスワードを変更.
     * <BR><BR>
     * 現在ユーザのパスワードを変更します.
     * <BR>
     * @param oldPasswd 現在のパスワードを設定します.
     * @param newPasswd 新しいパスワードを設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public void changeLoginUserPasswd( String oldPasswd,String newPasswd )
        throws MaachangQException ;
    
    /**
     * ルート権限の変更.
     * <BR><BR>
     * 対象ルート権限を変更します.<BR>
     * このメソッドは、管理者権限を持たない場合、処理できません.
     * <BR>
     * @param user 対象のユーザ名を設定します.
     * @param rootOwner 管理者権限を設定します.<BR>
     *                  [true]を設定した場合、管理者権限を持ちます.<BR>
     *                  [false]を設定した場合、一般権限を持ちます.
     * @exception MaachangQException MaachangQ例外.
     */
    public void changeRootOwner( String user,boolean rootOwner )
        throws MaachangQException ;
    
    /**
     * ユーザ情報一覧を取得.
     * <BR><BR>
     * ユーザ情報一覧を取得します.<BR>
     * このメソッドは、管理者権限を持たない場合、処理できません.
     * <BR>
     * @return UserInfo[] ユーザ情報一覧が返されます.
     * @exception MaachangQException MaachangQ例外.
     */
    public UserInfo[] getUserInfo() throws MaachangQException ;
    
    /**
     * 現在ユーザ数を取得.
     * <BR><BR>
     * 現在登録されているユーザ数を取得します.<BR>
     * このメソッドは、管理者権限を持たない場合、処理できません.
     * <BR>
     * @return int 現在のユーザ数が返されます.
     * @exception MaachangQException MaachangQ例外.
     */
    public int size() throws MaachangQException ;
    
    /**
     * 現在接続中のユーザ名を取得.
     * <BR><BR>
     * 現在接続中のユーザ名を取得します.
     * <BR>
     * @return String 現在接続中のユーザ名が返されます.
     */
    public String getUserName() ;
    
    /**
     * 接続ユーザの管理者権限を取得.
     * <BR><BR>
     * 接続ユーザの管理者権限を取得します.
     * <BR>
     * @return boolean 権限情報が返されます.<BR>
     *                 [true]が返された場合、コネクションユーザは管理者です.<BR>
     *                 [false]が返された場合、コネクションユーザは、一般ユーザです.
     */
    public boolean isRootOwner() ;
    
    /**
     * 指定ユーザに対する管理者権限を取得.
     * <BR><BR>
     * 指定ユーザに対する管理者権限を取得します.<BR>
     * このメソッドは、管理者権限を持たない場合、処理できません.
     * <BR>
     * @param user 対象ユーザを設定します.
     * @return boolean 権限情報が返されます.<BR>
     *                 [true]が返された場合、コネクションユーザは管理者です.<BR>
     *                 [false]が返された場合、コネクションユーザは、一般ユーザです.
     * @exception MaachangQException MaachangQ例外.
     */
    public boolean isRootOwner( String user )
        throws MaachangQException ;
    
    /**
     * 指定ユーザが存在するかチェック.
     * <BR><BR>
     * 指定ユーザが存在するかチェックします.<BR>
     * このメソッドは、管理者権限を持たない場合、処理できません.
     * <BR>
     * @param user 対象のユーザを設定します.
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]が返された場合、指定ユーザは存在します.<BR>
     *                 [false]が返された場合、指定ユーザは存在しません.
     * @exception MaachangQException MaachangQ例外.
     */
    public boolean isUser( String user )
        throws MaachangQException ;
    
    /**
     * 管理コネクションオブジェクトを取得.
     * <BR><BR>
     * 管理コネクションオブジェクトを取得します.
     * <BR>
     * @return MaachangQConnectAdmin 管理コネクションオブジェクトが返されます.
     */
    public MaachangQConnectAdmin getMaachangQConnectAdmin() ;
    
}

