/*
 * @(#)MaachangQAccessAdminDriver.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.admin ;

import java.net.InetAddress;
import java.net.Socket;

import org.maachang.queue.access.MaachangQAccessDefine;
import org.maachang.queue.access.MaachangQException;
import org.maachang.queue.access.net.ConnectObject;
import org.maachang.queue.access.net.CreateSocket;
import org.maachang.queue.access.protocol.login.LoginBean;


/**
 * MaachangQ-Access管理者接続.
 * <BR><BR>
 * MaachangQ-Access管理者接続オブジェクト.
 *  
 * @version 2007/01/02
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public class MaachangQAccessAdminDriver {
    
    private MaachangQAccessAdminDriver() { }
    
    /**
     * 同期オブジェクト.
     */
    private static final Object SYNC = new Object() ;
    
    /**
     * MaachangQ管理者に接続.
     * <BR><BR>
     * MaachangQ管理者に接続します.
     * <BR>
     * @param mode 対象のモードを設定します.<BR>
     *             [true]を設定した場合、SSLソケットを設定します.
     *             [false]を設定した場合、通常ソケットを設定します.
     * @param user ユーザ名を設定します.
     * @param passwd パスワードを設定します.
     * @return MaachangQConnectAdmin 管理者接続情報が返されます.
     * @exception MaachangQException MaachangQ例外.
     */
    public static final MaachangQConnectAdmin connect( boolean mode,String user,String passwd )
        throws MaachangQException {
        return MaachangQAccessAdminDriver.connect(
            mode,user,passwd,null,MaachangQAccessAdminDriver.getDefaultPort( mode ) ) ;
    }
    
    /**
     * MaachangQ管理者に接続.
     * <BR><BR>
     * MaachangQ管理者に接続します.
     * <BR>
     * @param mode 対象のモードを設定します.<BR>
     *             [true]を設定した場合、SSLソケットを設定します.
     *             [false]を設定した場合、通常ソケットを設定します.
     * @param user ユーザ名を設定します.
     * @param passwd パスワードを設定します.
     * @param port 接続先のポート番号を設定します.
     * @return MaachangQConnectAdmin 管理者接続情報が返されます.
     * @exception MaachangQException MaachangQ例外.
     */
    public static final MaachangQConnectAdmin connect( boolean mode,String user,String passwd,
        int port )
        throws MaachangQException {
        return MaachangQAccessAdminDriver.connect(
            mode,user,passwd,null,port ) ;
    }
    
    /**
     * MaachangQ管理者に接続.
     * <BR><BR>
     * MaachangQ管理者に接続します.
     * <BR>
     * @param mode 対象のモードを設定します.<BR>
     *             [true]を設定した場合、SSLソケットを設定します.
     *             [false]を設定した場合、通常ソケットを設定します.
     * @param user ユーザ名を設定します.
     * @param passwd パスワードを設定します.
     * @param address 接続先のアドレスを設定します.
     * @return MaachangQConnectAdmin 管理者接続情報が返されます.
     * @exception MaachangQException MaachangQ例外.
     */
    public static final MaachangQConnectAdmin connect( boolean mode,String user,String passwd,
        InetAddress address )
        throws MaachangQException {
        return MaachangQAccessAdminDriver.connect(
            mode,user,passwd,address,MaachangQAccessAdminDriver.getDefaultPort( mode ) ) ;
    }
    
    /**
     * MaachangQ管理者に接続.
     * <BR><BR>
     * MaachangQ管理者に接続します.
     * <BR>
     * @param mode 対象のモードを設定します.<BR>
     *             [true]を設定した場合、SSLソケットを設定します.
     *             [false]を設定した場合、通常ソケットを設定します.
     * @param user ユーザ名を設定します.
     * @param passwd パスワードを設定します.
     * @param address 接続先のアドレスを設定します.
     * @param port 接続先のポート番号を設定します.
     * @return MaachangQConnectAdmin 管理者接続情報が返されます.
     * @exception MaachangQException MaachangQ例外.
     */
    public static final MaachangQConnectAdmin connect( boolean mode,String user,String passwd,
        InetAddress address,int port )
        throws MaachangQException {
        if( port < 0 || port > 65535 ||
            user == null || ( user = user.trim() ).length() <= 0 ) {
            throw new MaachangQException( "引数は不正です" ) ;
        }
        
        try {
            synchronized( SYNC ) {
                
                // アドレスがnullの場合、ローカルホスト接続.
                if( address == null ) {
                    address = InetAddress.getByName( "127.0.0.1" ) ;
                }
                
                Socket socket = CreateSocket.clientSocket( mode,address,port ) ;
                ConnectObject connect = new ConnectObject( socket ) ;
                
                // ログイン処理.
                LoginBean bean = ExecutionLogin.login( connect,user,passwd ) ;
                
                return new MaachangQConnectAdminImple(
                    connect,bean.getId(),bean.isRootOwner(),user,passwd ) ;
                
            }
        } catch( MaachangQException fm ) {
            throw fm ;
        } catch( Exception e ) {
            throw new MaachangQException( e ) ;
        }
    }
    
    /**
     * デフォルトポートを取得.
     */
    private static final int getDefaultPort( boolean mode ) {
        if( mode == true ) {
            return MaachangQAccessDefine.SSL_ADMIN_PORT ;
        }
        return MaachangQAccessDefine.ADMIN_PORT ;
    }
    
}

