/*
 * @(#)ChannelInfo.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.admin.info ;

import org.maachang.queue.access.MaachangQAccessDefine;


/**
 * チャネル情報.
 * <BR><BR>
 * チャネル情報を表すオブジェクト.
 *  
 * @version 2007/01/03
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public class ChannelInfo {
    
    /**
     * チャネル名.
     */
    private String channelName = null ;
    
    /**
     * チャネルステータス.
     */
    private int state = -1 ;
    
    /**
     * コンストラクタ.
     */
    public ChannelInfo() {
        
    }
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報をクリアします.
     */
    public void clear() {
        channelName = null ;
        state = -1 ;
    }

    /**
     * channelName を取得.
     * <BR><BR>
     * @return channelName が返されます.
     */
    public String getChannelName() {
        return channelName;
    }

    /**
     * channelName を設定.
     * <BR><BR>
     * @param channelName channelName を設定します.
     */
    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    /**
     * state を取得.
     * <BR><BR>
     * @return state が返されます.
     */
    public int getState() {
        return state;
    }

    /**
     * state を設定.
     * <BR><BR>
     * @param state state を設定します.
     */
    public void setState(int state) {
        this.state = state;
    }
    
    /**
     * channelType を取得.
     * <BR><BR>
     * @return channelType が返されます.
     */
    public int getChannelType() {
        if( this instanceof SendChannelRef ) {
            return MaachangQAccessDefine.TYPE_SEND ;
        }
        return MaachangQAccessDefine.TYPE_RECEIVE ;
    }
}

