/*
 * @(#)CreateCacheInfo.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.admin.info ;


/**
 * キャッシュ生成情報.
 * <BR><BR>
 * キャッシュ生成情報を表すオブジェクト.
 *  
 * @version 2007/01/03
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public class CreateCacheInfo implements Comparable {
    
    /**
     * コネクション名.
     */
    private String name = null ;
    
    /**
     * キャッシュ数.
     */
    private int size = -1 ;
    
    /**
     * コンストラクタ.
     */
    public CreateCacheInfo() {
        
    }

    /**
     * name を取得.
     * <BR><BR>
     * @return name が返されます.
     */
    public String getName() {
        return name;
    }

    /**
     * name を設定.
     * <BR><BR>
     * @param name name を設定します.
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * size を取得.
     * <BR><BR>
     * @return size が返されます.
     */
    public int getSize() {
        return size;
    }

    /**
     * size を設定.
     * <BR><BR>
     * @param size size を設定します.
     */
    public void setSize(int size) {
        this.size = size;
    }
    
    /**
     * オブジェクト比較.
     * <BR><BR>
     * オブジェクトを比較します.
     * <BR>
     * @param o 比較元のオブジェクトを設定します.
     * @return int 比較結果が返されます.
     */
    public int compareTo(Object o) {
        
        return name.compareTo( ( ( CreateCacheInfo )o ).name ) ;
        
    }

}

