/*
 * @(#)CreateChannelInfo.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.admin.info ;

import org.maachang.queue.access.MaachangQAccessDefine;


/**
 * チャネル生成情報.
 * <BR><BR>
 * チャネル生成情報を表すオブジェクト.
 *  
 * @version 2007/01/03
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public class CreateChannelInfo implements Comparable {
    
    /**
     * チャネル名.
     */
    private String channelName = null ;
    
    /**
     * コンストラクタ.
     */
    public CreateChannelInfo() {
        
    }
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報をクリアします.
     */
    public void clear() {
        channelName = null ;
    }

    /**
     * channelName を取得.
     * <BR><BR>
     * @return channelName が返されます.
     */
    public String getChannelName() {
        return channelName;
    }

    /**
     * channelName を設定.
     * <BR><BR>
     * @param channelName channelName を設定します.
     */
    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }
    
    /**
     * channelType を取得.
     * <BR><BR>
     * @return channelType が返されます.
     */
    public int getChannelType() {
        if( this instanceof SendChannelRef ) {
            return MaachangQAccessDefine.TYPE_SEND ;
        }
        return MaachangQAccessDefine.TYPE_RECEIVE ;
    }
    
    /**
     * オブジェクト比較.
     * <BR><BR>
     * オブジェクトを比較します.
     * <BR>
     * @param o 比較元のオブジェクトを設定します.
     * @return int 比較結果が返されます.
     */
    public int compareTo(Object o) {
        
        return channelName.compareTo( ( ( CreateChannelInfo )o ).channelName ) ;
        
    }
}

