/*
 * @(#)CreateQueueInfo.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.admin.info ;

import org.maachang.queue.access.MaachangQAccessDefine;

/**
 * キュー生成用情報.
 * <BR><BR>
 * キュー生成用情報を表すオブジェクト.
 *  
 * @version 2007/01/03
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public class CreateQueueInfo implements Comparable {
    
    /**
     * キュー名.
     */
    private String queue = null ;
    
    /**
     * メッセージ長制限.
     */
    private int maxMessageLength = -1 ;
    
    /**
     * 最大キューサイズ.
     */
    private int maxQueueSize = MaachangQAccessDefine.DEFAULT_QUEUE_SIZE ;
    
    /**
     * 警告キューサイズ.
     */
    private int warningPersend = MaachangQAccessDefine.DEFAULT_WARNING_PARSENT ;
    
    /**
     * 圧縮フラグ.
     */
    private boolean gzipFlag = false ;
    
    /**
     * オートコミット.
     */
    private boolean autoCommit = false ;
    
    /**
     * キャッシュ名.
     */
    private String cacheName = null ;
    
    /**
     * コンストラクタ.
     */
    public CreateQueueInfo() {
        
    }
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報をクリアします.
     */
    public void clear() {
        queue = null ;
        maxMessageLength = -1 ;
        maxQueueSize = MaachangQAccessDefine.DEFAULT_QUEUE_SIZE ;
        warningPersend = MaachangQAccessDefine.DEFAULT_WARNING_PARSENT ;
        gzipFlag = false ;
        autoCommit = false ;
        cacheName = null ;
    }

    /**
     * maxMessageLength を取得.
     * <BR><BR>
     * @return maxMessageLength が返されます.
     */
    public int getMaxMessageLength() {
        return maxMessageLength;
    }

    /**
     * maxMessageLength を設定.
     * <BR><BR>
     * @param maxMessageLength maxMessageLength を設定します.
     */
    public void setMaxMessageLength(int maxMessageLength) {
        this.maxMessageLength = maxMessageLength;
    }

    /**
     * autoCommit を取得.
     * <BR><BR>
     * @return autoCommit が返されます.
     */
    public boolean isAutoCommit() {
        return autoCommit;
    }

    /**
     * autoCommit を設定.
     * <BR><BR>
     * @param autoCommit autoCommit を設定します.
     */
    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    /**
     * gzipFlag を取得.
     * <BR><BR>
     * @return gzipFlag が返されます.
     */
    public boolean isGzipFlag() {
        return gzipFlag;
    }

    /**
     * gzipFlag を設定.
     * <BR><BR>
     * @param gzipFlag gzipFlag を設定します.
     */
    public void setGzipFlag(boolean gzipFlag) {
        this.gzipFlag = gzipFlag;
    }

    /**
     * maxQueueSize を取得.
     * <BR><BR>
     * @return maxQueueSize が返されます.
     */
    public int getMaxQueueSize() {
        return maxQueueSize;
    }

    /**
     * maxQueueSize を設定.
     * <BR><BR>
     * @param maxQueueSize maxQueueSize を設定します.
     */
    public void setMaxQueueSize(int maxQueueSize) {
        if( maxQueueSize <= MaachangQAccessDefine.MIN_QUEUE_SIZE ) {
            maxQueueSize = MaachangQAccessDefine.MIN_QUEUE_SIZE ;
        }
        else if( maxQueueSize >= MaachangQAccessDefine.MAX_QUEUE_SIZE ) {
            maxQueueSize = MaachangQAccessDefine.MAX_QUEUE_SIZE ;
        }
        this.maxQueueSize = maxQueueSize;
    }

    /**
     * queue を取得.
     * <BR><BR>
     * @return queue が返されます.
     */
    public String getQueue() {
        return queue;
    }

    /**
     * queue を設定.
     * <BR><BR>
     * @param queue queue を設定します.
     */
    public void setQueue(String queue) {
        if( queue != null &&
            ( queue = queue.trim().toLowerCase() ).length() > 0 ) {
            this.queue = queue;
        }
    }

    /**
     * type を取得.
     * <BR><BR>
     * @return type が返されます.
     */
    public int getType() {
        if( this instanceof SendQueueChannelRef ) {
            return MaachangQAccessDefine.TYPE_SEND ;
        }
        return MaachangQAccessDefine.TYPE_RECEIVE ;
    }

    /**
     * warningPersend を取得.
     * <BR><BR>
     * @return warningPersend が返されます.
     */
    public int getWarningPersend() {
        return warningPersend;
    }

    /**
     * warningPersend を設定.
     * <BR><BR>
     * @param warningPersend warningPersend を設定します.
     */
    public void setWarningPersend(int warningPersend) {
        if( warningPersend <= MaachangQAccessDefine.MIN_WARNING_PARSEND ) {
            warningPersend = MaachangQAccessDefine.MIN_WARNING_PARSEND ;
        }
        else if( warningPersend >= MaachangQAccessDefine.MAX_WARNING_PARSEND ) {
            warningPersend = MaachangQAccessDefine.MAX_WARNING_PARSEND ;
        }
        this.warningPersend = warningPersend;
    }
    
    /**
     * オブジェクト比較.
     * <BR><BR>
     * オブジェクトを比較します.
     * <BR>
     * @param o 比較元のオブジェクトを設定します.
     * @return int 比較結果が返されます.
     */
    public int compareTo(Object o) {
        
        return queue.compareTo( ( ( CreateQueueInfo )o ).queue ) ;
        
    }

    /**
     * cacheName を取得.
     * <BR><BR>
     * @return cacheName が返されます.
     */
    public String getCacheName() {
        return cacheName;
    }

    /**
     * cacheName を設定.
     * <BR><BR>
     * @param cacheName cacheName を設定します.
     */
    public void setCacheName(String cacheName) {
        if( cacheName == null ||
        ( cacheName = cacheName.trim().toLowerCase() ).length() <= 0 ) {
            return ;
        }
        this.cacheName = cacheName;
    }

}

