/*
 * @(#)CreateQueueManagerInfo.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.admin.info ;

import org.maachang.queue.access.MaachangQAccessDefine;

/**
 * キューマネージャ生成用情報.
 * <BR><BR>
 * キューマネージャ生成用情報表すオブジェクト.
 *  
 * @version 2007/01/03
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public class CreateQueueManagerInfo implements Comparable {
    
    /**
     * キューマネージャ名.
     */
    private String queueManager = null ;
    
    /**
     * 最大キャッシュセクタ数.
     */
    private int maxCacheSize = -1 ;
    
    /**
     * コンストラクタ.
     */
    public CreateQueueManagerInfo() {
        
    }

    /**
     * maxCacheSize を取得.
     * <BR><BR>
     * @return maxCacheSize が返されます.
     */
    public int getMaxCacheSize() {
        return maxCacheSize;
    }

    /**
     * maxCacheSize を設定.
     * <BR><BR>
     * @param maxCacheSize キャッシュセクタ数を設定します.<BR>
     *                     設定可能な最小値は[MaachangQAccessDefine.MIN_CACHE_SECTOR]です.<BR>
     *                     設定可能な最大値は[MaachangQAccessDefine.MAX_CACHE_SECTOR]です.<BR>
     *                     [-1]を設定した場合、キャッシュファイルは生成されません.

     */
    public void setMaxCacheSize(int maxCacheSize) {
        if( maxCacheSize <= 0 ) {
            maxCacheSize = -1 ;
        }
        else if( maxCacheSize <= MaachangQAccessDefine.MIN_CACHE_SECTOR ) {
            maxCacheSize = MaachangQAccessDefine.MIN_CACHE_SECTOR ;
        }
        else if( maxCacheSize >= MaachangQAccessDefine.MAX_CACHE_SECTOR ) {
            maxCacheSize = MaachangQAccessDefine.MAX_CACHE_SECTOR ;
        }
        this.maxCacheSize = maxCacheSize;
    }

    /**
     * queueManager を取得.
     * <BR><BR>
     * @return queueManager が返されます.
     */
    public String getQueueManager() {
        return queueManager;
    }

    /**
     * queueManager を設定.
     * <BR><BR>
     * @param queueManager queueManager を設定します.
     */
    public void setQueueManager(String queueManager) {
        if( queueManager != null &&
            ( queueManager = queueManager.trim().toLowerCase() ).length() > 0 ) {
            this.queueManager = queueManager;
        }
    }
    
    /**
     * オブジェクト比較.
     * <BR><BR>
     * オブジェクトを比較します.
     * <BR>
     * @param o 比較元のオブジェクトを設定します.
     * @return int 比較結果が返されます.
     */
    public int compareTo(Object o) {
        
        return queueManager.compareTo( ( ( CreateQueueManagerInfo )o ).queueManager ) ;
        
    }

}

