/*
 * @(#)CreateUserInfo.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.admin.info ;

/**
 * ユーザ生成情報.
 * <BR><BR>
 * ユーザ生成情報を表すオブジェクト.
 *  
 * @version 2007/01/02
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public class CreateUserInfo implements Comparable {
    
    /**
     * ユーザ名.
     */
    private String user = null ;
    
    /**
     * ルート権限.
     */
    private boolean rootOwner = false ;
    
    /**
     * コンストラクタ.
     */
    public CreateUserInfo() {
        
    }

    /**
     * rootOwner を取得.
     * <BR><BR>
     * @return rootOwner が返されます.
     */
    public boolean isRootOwner() {
        return rootOwner;
    }

    /**
     * rootOwner を設定.
     * <BR><BR>
     * @param rootOwner rootOwner を設定します.
     */
    public void setRootOwner(boolean rootOwner) {
        this.rootOwner = rootOwner;
    }

    /**
     * user を取得.
     * <BR><BR>
     * @return user が返されます.
     */
    public String getUser() {
        return user;
    }

    /**
     * user を設定.
     * <BR><BR>
     * @param user user を設定します.
     */
    public void setUser(String user) {
        this.user = user;
    }
    
    /**
     * オブジェクト比較.
     * <BR><BR>
     * オブジェクトを比較します.
     * <BR>
     * @param o 比較元のオブジェクトを設定します.
     * @return int 比較結果が返されます.
     */
    public int compareTo(Object o) {
        
        return user.compareTo( ( ( CreateUserInfo )o ).user ) ;
        
    }

}

