/*
 * @(#)QueueInfo.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.admin.info ;

import org.maachang.queue.access.MaachangQAccessDefine;

/**
 * キュー情報.
 * <BR><BR>
 * キュー情報を表すオブジェクト.
 *  
 * @version 2007/01/03
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public class QueueInfo extends CreateQueueInfo {
    
    /**
     * キューマネージャ名.
     */
    private String queueManager = null ;
    
    /**
     * ステータス.
     */
    private int state = -1 ;
    
    /**
     * 現在キューサイズ.
     */
    private int useQueueSize = -1 ;
        
    /**
     * コンストラクタ.
     */
    public QueueInfo() {
        
    }
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報をクリアします.
     */
    public void clear() {
        
        super.clear() ;
        
        queueManager = null ;
        state = -1 ;
        useQueueSize = -1 ;
        
    }

    /**
     * queueManager を取得.
     * <BR><BR>
     * @return queueManager が返されます.
     */
    public String getQueueManager() {
        return queueManager;
    }

    /**
     * queueManager を設定.
     * <BR><BR>
     * @param queueManager queueManager を設定します.
     */
    public void setQueueManager(String queueManager) {
        this.queueManager = queueManager;
    }

    /**
     * state を取得.
     * <BR><BR>
     * @return state が返されます.
     */
    public int getState() {
        return state;
    }

    /**
     * state を設定.
     * <BR><BR>
     * @param state state を設定します.
     */
    public void setState(int state) {
        this.state = state;
    }

    /**
     * useQueueSize を取得.
     * <BR><BR>
     * @return useQueueSize が返されます.
     */
    public int getUseQueueSize() {
        return useQueueSize;
    }

    /**
     * useQueueSize を設定.
     * <BR><BR>
     * @param useQueueSize useQueueSize を設定します.
     */
    public void setUseQueueSize(int useQueueSize) {
        this.useQueueSize = useQueueSize;
    }
    
    /**
     * type を取得.
     * <BR><BR>
     * @return type が返されます.
     */
    public int getType() {
        if( this instanceof SendQueueChannelRef ) {
            return MaachangQAccessDefine.TYPE_SEND ;
        }
        return MaachangQAccessDefine.TYPE_RECEIVE ;
    }
    
}

