/*
 * @(#)QueueManagerInfo.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.admin.info ;

/**
 * キューマネージャ情報.
 * <BR><BR>
 * キューマネージャ情報を表すオブジェクト.
 *  
 * @version 2007/01/03
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public class QueueManagerInfo extends CreateQueueManagerInfo {
    
    /**
     * キューキャッシュ利用状況.
     */
    private boolean useCache = false ;
    
    /**
     * 現在利用キャッシュセクタ数.
     */
    private int useCacheSize = -1 ;
    
    /**
     * キューマネージャステータス.
     */
    private int state = -1 ;
    
    /**
     * コンストラクタ.
     */
    public QueueManagerInfo() {
        
    }

    /**
     * state を取得.
     * <BR><BR>
     * @return state が返されます.
     */
    public int getState() {
        return state;
    }

    /**
     * state を設定.
     * <BR><BR>
     * @param state state を設定します.
     */
    public void setState(int state) {
        this.state = state;
    }

    /**
     * useCache を取得.
     * <BR><BR>
     * @return useCache が返されます.
     */
    public boolean isUseCache() {
        return useCache;
    }

    /**
     * useCache を設定.
     * <BR><BR>
     * @param useCache useCache を設定します.
     */
    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    /**
     * useCacheSize を取得.
     * <BR><BR>
     * @return useCacheSize が返されます.
     */
    public int getUseCacheSize() {
        return useCacheSize;
    }

    /**
     * useCacheSize を設定.
     * <BR><BR>
     * @param useCacheSize useCacheSize を設定します.
     */
    public void setUseCacheSize(int useCacheSize) {
        this.useCacheSize = useCacheSize;
    }
    
}

