/*
 * @(#)SendChannelInfo.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.admin.info ;

import java.net.InetAddress;

/**
 * 送信チャネル情報.
 * <BR><BR>
 * 送信チャネル情報を表すオブジェクト.
 *  
 * @version 2007/01/03
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public class SendChannelInfo
    extends ChannelInfo implements SendChannelRef {
    
    /**
     * 接続先キューマネージャ名.
     */
    private String queueManager = null ;
    
    /**
     * 接続先IPアドレス.
     */
    private InetAddress address = null ;
    
    /**
     * 接続先ポート.
     */
    private int port = -1 ;
    
    /**
     * コネクション名.
     */
    private String connectName = null ;
    
    /**
     * 利用暗号ワード.
     */
    private String useCb32Word = null ;
    
    /**
     * コンストラクタ.
     */
    public SendChannelInfo() {
        
    }
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報をクリアします.
     */
    public void clear() {
        super.clear() ;
        
        queueManager = null ;
        address = null ;
        port = -1 ;
        connectName = null ;
        useCb32Word = null ;
    }

    /**
     * queueManager を取得.
     * <BR><BR>
     * @return queueManager が返されます.
     */
    public String getQueueManager() {
        return queueManager;
    }

    /**
     * queueManager を設定.
     * <BR><BR>
     * @param queueManager queueManager を設定します.
     */
    public void setQueueManager(String queueManager) {
        this.queueManager = queueManager;
    }

    /**
     * address を取得.
     * <BR><BR>
     * @return address が返されます.
     */
    public InetAddress getAddress() {
        return address;
    }

    /**
     * address を設定.
     * <BR><BR>
     * @param address address を設定します.
     */
    public void setAddress(InetAddress address) {
        this.address = address;
    }

    /**
     * connectName を取得.
     * <BR><BR>
     * @return connectName が返されます.
     */
    public String getConnectName() {
        return connectName;
    }

    /**
     * connectName を設定.
     * <BR><BR>
     * @param connectName connectName を設定します.
     */
    public void setConnectName(String connectName) {
        this.connectName = connectName;
    }

    /**
     * port を取得.
     * <BR><BR>
     * @return port が返されます.
     */
    public int getPort() {
        return port;
    }

    /**
     * port を設定.
     * <BR><BR>
     * @param port port を設定します.
     */
    public void setPort(int port) {
        this.port = port;
    }

    /**
     * useCb32Word を取得.
     * <BR><BR>
     * @return useCb32Word が返されます.
     */
    public String getUseCb32Word() {
        return useCb32Word;
    }

    /**
     * useCb32Word を設定.
     * <BR><BR>
     * @param useCb32Word useCb32Word を設定します.
     */
    public void setUseCb32Word(String useCb32Word) {
        this.useCb32Word = useCb32Word;
    }
    
}

