/*
 * @(#)SendChannelRef.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.admin.info ;

import java.net.InetAddress;

/**
 * 送信チャネル情報.
 * <BR><BR>
 * 送信チャネル情報を表すインターフェイス.
 *  
 * @version 2007/01/03
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public interface SendChannelRef {
    
    /**
     * queueManager を取得.
     * <BR><BR>
     * @return queueManager が返されます.
     */
    public String getQueueManager() ;
    
    /**
     * address を取得.
     * <BR><BR>
     * @return address が返されます.
     */
    public InetAddress getAddress() ;

    /**
     * address を設定.
     * <BR><BR>
     * @param address address を設定します.
     */
    public void setAddress(InetAddress address) ;

    /**
     * connectName を取得.
     * <BR><BR>
     * @return connectName が返されます.
     */
    public String getConnectName() ;

    /**
     * connectName を設定.
     * <BR><BR>
     * @param connectName connectName を設定します.
     */
    public void setConnectName(String connectName) ;

    /**
     * port を取得.
     * <BR><BR>
     * @return port が返されます.
     */
    public int getPort() ;

    /**
     * port を設定.
     * <BR><BR>
     * @param port port を設定します.
     */
    public void setPort(int port) ;
    
    /**
     * useCb32Word を取得.
     * <BR><BR>
     * @return useCb32Word が返されます.
     */
    public String getUseCb32Word() ;

    /**
     * useCb32Word を設定.
     * <BR><BR>
     * @param useCb32Word useCb32Word を設定します.
     */
    public void setUseCb32Word(String useCb32Word) ;
    
}

