/*
 * @(#)SendQueueChannel.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.admin.info ;

/**
 * 送信キューチャネル定義用情報.
 * <BR><BR>
 * 送信キューチャネル定義用の情報を表すインターフェイス.
 *  
 * @version 2007/01/03
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public interface SendQueueChannelRef {
    
    /**
     * チャネル名追加.
     * <BR><BR>
     * 新しいチャネル名を追加します.
     * <BR>
     * @param name 対象のチャネル名を設定します.
     */
    public void addChannel( String name ) ;
    
    /**
     * チャネル名を削除.
     * <BR><BR>
     * 指定したチャネル名を削除します.
     * <BR>
     * @param name 削除対象のチャネル名を設定します.
     */
    public void removeChannel( String name ) ;
    
    /**
     * チャネル名を取得.
     * <BR><BR>
     * 指定項番のチャネル名を取得します.
     * <BR>
     * @param no 対象の項番を設定します.
     * @return String 対象のチャネル名が返されます.
     */
    public String getChannel( int no ) ;
    
    /**
     * 設定チャネル数を取得.
     * <BR><BR>
     * 設定されているチャネル数を取得.
     * <BR>
     * @return int 設定されているチャネル数が返されます.
     */
    public int getChannelSize() ;
    
    /**
     * 対象チャネル名が存在するかチェック.
     * <BR><BR>
     * 対象のチャネル名が既に存在するかチェックします.
     * <BR>
     * @param name 対象のチャネル名を設定します.
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]が返された場合、チャネル名は既に存在します.<BR>
     *                 [false]が返された場合、チャネル名は存在しません.
     */
    public boolean isChannel( String name ) ;
    
}

