/*
 * @(#)SendQueueInfo.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.admin.info ;

import java.util.ArrayList;

/**
 * 送信キューチャネル定義用情報.
 * <BR><BR>
 * 送信キューチャネル定義用の情報を表すオブジェクト.
 *  
 * @version 2007/01/03
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public class SendQueueInfo
    extends QueueInfo implements SendQueueChannelRef {
    
    /**
     * チャネル名格納.
     */
    private final ArrayList channelNames = new ArrayList() ;
    
    /**
     * コンストラクタ.
     */
    public SendQueueInfo() {
        
    }
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報をクリアします.
     */
    public void clear() {
        super.clear() ;
        channelNames.clear() ;
    }
    
    /**
     * チャネル名群を設定.
     * <BR><BR>
     * チャネル名群を設定します.
     * <BR>
     * @param names 対象のチャネル名群を設定します.
     */
    public void setChannels( String[] names ) {
        if( names != null ) {
            int len = names.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                channelNames.add( names[ i ] ) ;
            }
        }
    }
    
    /**
     * チャネル名追加.
     * <BR><BR>
     * 新しいチャネル名を追加します.
     * <BR>
     * @param name 対象のチャネル名を設定します.
     */
    public void addChannel( String name ) {
        if( name == null || ( name = name.trim().toLowerCase() ).length() <= 0 ) {
            return ;
        }
        
        int len = channelNames.size() ;
        for( int i = 0 ; i < len  ; i ++ ) {
            if( name.equals( ( String )channelNames.get( i ) ) == true ) {
                return ;
            }
        }
        
        channelNames.add( name ) ;
    }
    
    /**
     * チャネル名を削除.
     * <BR><BR>
     * 指定したチャネル名を削除します.
     * <BR>
     * @param name 削除対象のチャネル名を設定します.
     */
    public void removeChannel( String name ) {
        if( name == null || ( name = name.trim().toLowerCase() ).length() <= 0 ) {
            return ;
        }
        
        int len = channelNames.size() ;
        for( int i = 0 ; i < len  ; i ++ ) {
            if( name.equals( ( String )channelNames.get( i ) ) == true ) {
                channelNames.remove( i ) ;
                break ;
            }
        }
    }
    
    /**
     * チャネル名を取得.
     * <BR><BR>
     * 指定項番のチャネル名を取得します.
     * <BR>
     * @param no 対象の項番を設定します.
     * @return String 対象のチャネル名が返されます.
     */
    public String getChannel( int no ) {
        
        if( no < 0 || no >= channelNames.size() ) {
            return null ;
        }
        
        return ( String )channelNames.get( no ) ;
    }
    
    /**
     * チャネル名一覧を取得.
     * <BR><BR>
     * 対象のチャネル名一覧を取得します.
     * <BR>
     * @return String[] チャネル名一覧が返されます.
     */
    public String[] getChannelNames() {
        
        int len = channelNames.size() ;
        if( len > 0 ) {
            String[] ret = new String[ len ] ;
            for( int i = 0 ; i < len ; i ++ ) {
                ret[ i ] = ( String )channelNames.get( i ) ;
            }
            return ret ;
        }
        
        return null ;
    }
    
    /**
     * 設定チャネル数を取得.
     * <BR><BR>
     * 設定されているチャネル数を取得.
     * <BR>
     * @return int 設定されているチャネル数が返されます.
     */
    public int getChannelSize() {
        return channelNames.size() ;
    }
    
    /**
     * 対象チャネル名が存在するかチェック.
     * <BR><BR>
     * 対象のチャネル名が既に存在するかチェックします.
     * <BR>
     * @param name 対象のチャネル名を設定します.
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]が返された場合、チャネル名は既に存在します.<BR>
     *                 [false]が返された場合、チャネル名は存在しません.
     */
    public boolean isChannel( String name ) {
        if( name == null || ( name = name.trim().toLowerCase() ).length() <= 0 ) {
            return false ;
        }
        
        int len = channelNames.size() ;
        for( int i = 0 ; i < len  ; i ++ ) {
            if( name.equals( ( String )channelNames.get( i ) ) == true ) {
                return true ;
            }
        }
        
        return false ;
    }
    
}

