/*
 * @(#)MessageBean.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.protocol ;

import org.maachang.queue.access.MaachangQAccessDefine;

/**
 * 電文送受信Bean.
 *  
 * @version 2007/01/08
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public class MessageBean extends BaseProtocolBean {
    
    /**
     * メッセージKey.
     */
    private String key = null ;
    
    /**
     * プロセスID.
     */
    private String processId = null ;
    
    /**
     * メッセージ情報.
     */
    private byte[] message = null ;
    
    /**
     * Expire値.
     */
    private int expire = -1 ;
    
    /**
     * プライオリティ値.
     */
    private int priority = MaachangQAccessDefine.DEFAULT_PRIORITY ;
    
    /**
     * コンストラクタ.
     */
    public MessageBean() {
        
    }
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報をクリアします.
     */
    public void clear() {
        super.clear() ;
        key = null ;
        processId = null ;
        message = null ;
    }

    /**
     * key を取得.
     * <BR><BR>
     * @return key が返されます.
     */
    public String getKey() {
        return key;
    }

    /**
     * key を設定.
     * <BR><BR>
     * @param key key を設定します.
     */
    public void setKey(String key) {
        this.key = key;
    }

    /**
     * message を取得.
     * <BR><BR>
     * @return message が返されます.
     */
    public byte[] getMessage() {
        return message;
    }

    /**
     * message を設定.
     * <BR><BR>
     * @param message message を設定します.
     */
    public void setMessage(byte[] message) {
        this.message = message;
    }

    /**
     * expire を取得.
     * <BR><BR>
     * @return expire が返されます.
     */
    public int getExpire() {
        return expire;
    }

    /**
     * expire を設定.
     * <BR><BR>
     * @param expire expire を設定します.
     */
    public void setExpire(int expire) {
        this.expire = expire;
    }

    /**
     * priority を取得.
     * <BR><BR>
     * @return priority が返されます.
     */
    public int getPriority() {
        return priority;
    }

    /**
     * priority を設定.
     * <BR><BR>
     * @param priority priority を設定します.
     */
    public void setPriority(int priority) {
        this.priority = priority;
    }

    /**
     * processId を取得.
     * <BR><BR>
     * @return processId が返されます.
     */
    public String getProcessId() {
        return processId;
    }

    /**
     * processId を設定.
     * <BR><BR>
     * @param processId processId を設定します.
     */
    public void setProcessId(String processId) {
        this.processId = processId;
    }
    
}
