/*
 * @(#)ResultBean.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.protocol ;

import org.maachang.queue.access.MaachangQErrorCode;

/**
 * 処理結果Bean.
 *  
 * @version 2007/01/08
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public class ResultBean extends BaseProtocolBean {
    
    /**
     * 元の処理タイプ.
     */
    private int srcType = -1 ;
    
    /**
     * 処理結果コード.
     */
    private int resultCode = MaachangQErrorCode.SUCCESS ;
    
    /**
     * 処理エラーメッセージ.
     */
    private String errorMessage = null ;
    
    /**
     * コンストラクタ.
     */
    public ResultBean() {
        
    }
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報をクリアします.
     */
    public void clear() {
        super.clear() ;
        errorMessage = null ;
    }

    /**
     * srcType を取得.
     * <BR><BR>
     * @return srcType が返されます.
     */
    public int getSrcType() {
        return srcType;
    }

    /**
     * srcType を設定.
     * <BR><BR>
     * @param srcType srcType を設定します.
     */
    public void setSrcType(int srcType) {
        this.srcType = srcType;
    }

    /**
     * errorMessage を取得.
     * <BR><BR>
     * @return errorMessage が返されます.
     */
    public String getErrorMessage() {
        return errorMessage;
    }

    /**
     * errorMessage を設定.
     * <BR><BR>
     * @param errorMessage errorMessage を設定します.
     */
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    /**
     * resultCode を取得.
     * <BR><BR>
     * @return resultCode が返されます.
     */
    public int getResultCode() {
        return resultCode;
    }

    /**
     * resultCode を設定.
     * <BR><BR>
     * @param resultCode resultCode を設定します.
     */
    public void setResultCode(int resultCode) {
        this.resultCode = resultCode;
    }

}
