/*
 * @(#)ResultTelegram.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.protocol ;

import org.maachang.queue.access.MaachangQErrorCode;
import org.maachang.queue.access.MaachangQException;

/**
 * 処理戻り電文解析.
 *  
 * @version 2007/01/11
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public class ResultTelegram {
    
    /**
     * 処理結果電文解析.
     * <BR><BR>
     * 受信電文を処理結果電文として解析します.
     * <BR>
     * @param out メッセージBeanを設定します.
     * @param telegram 受信電文を設定します.
     * @exception Exception 例外.
     */
    public static final void analysisResultTelegram( ResultBean out,byte[] telegram )
        throws Exception {
        
        if( out == null ) {
            throw new IllegalArgumentException( "out引数は不正です" ) ;
        }
        
        int[] outId = new int[ 1 ] ;
        byte[] bin = CommonProtocol.analysisProtocol( null,outId,telegram ) ;
        ResultProtocol.analysisProtocol( out,bin ) ;
        
        out.setId( outId[ 0 ] ) ;
        
    }
    
    /**
     * 対象結果電文をチェック.
     * <BR><BR>
     * 対象結果電文のチェック処理を行います.
     * <BR>
     * @param id 対象の電文IDを設定します.
     * @param srcType 送信元の電文タイプを設定します.
     * @param telegram 対象の電文情報を設定します.
     * @return ResultBean 解析された戻り情報が返されます.
     * @exception MaachangQException MaachangQ例外.
     */
    public static final ResultBean checkResult( int id,int srcType,byte[] telegram )
        throws MaachangQException {
        
        try {
            
            ResultBean out = new ResultBean() ;
            ResultTelegram.analysisResultTelegram( out,telegram ) ;
            
            if( ( srcType != -1 && out.getSrcType() != -1 &&
                    out.getSrcType() != srcType ) ||
                out.getId() != id ) {
                throw new MaachangQException( "受信電文は不正です" ) ;
            }
            
            if( out.getResultCode() != MaachangQErrorCode.SUCCESS ) {
                throw new MaachangQException(
                    out.getErrorMessage(),out.getResultCode() ) ;
            }
            
            return out ;
            
        } catch( MaachangQException fm ) {
            throw fm ;
        } catch( Exception e ) {
            throw new MaachangQException( e ) ;
        }
        
    }
    
    /**
     * 対象結果電文をチェック.
     * <BR><BR>
     * 対象結果電文のチェック処理を行います.
     * <BR>
     * @param id 対象の電文IDを設定します.
     * @param srcType 送信元の電文タイプを設定します.
     * @param telegram 対象の電文情報を設定します.
     * @return boolean Boolean戻り値が返されます.
     * @exception MaachangQException MaachangQ例外.
     */
    public static final boolean checkResultByMessageBoolean( int id,int srcType,byte[] telegram )
        throws MaachangQException {
        
        try {
            
            ResultBean out = new ResultBean() ;
            ResultTelegram.analysisResultTelegram( out,telegram ) ;
            
            if( ( srcType != -1 && out.getSrcType() != -1 &&
                    out.getSrcType() != srcType ) ||
                out.getId() != id ) {
                throw new MaachangQException( "受信電文は不正です" ) ;
            }
            
            if( out.getResultCode() != MaachangQErrorCode.SUCCESS ) {
                throw new MaachangQException(
                    out.getErrorMessage(),out.getResultCode() ) ;
            }
            
            return ( out.getErrorMessage() != null &&
                "true".equals( out.getErrorMessage().trim().toLowerCase() ) ) ?
                true : false ;
            
        } catch( MaachangQException fm ) {
            throw fm ;
        } catch( Exception e ) {
            throw new MaachangQException( e ) ;
        }
        
    }
    
}

