/*
 * @(#)AdminQueueBean.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.protocol.admin ;

/**
 * 管理者用キューBean.
 *  
 * @version 2007/01/05
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public class AdminQueueBean extends BaseAdminProtocolBean{
    
    /**
     * キューマネージャ名.
     */
    private String manager = null ;
    
    /**
     * キュータイプ.
     */
    private int queueType = -1 ;
    
    /**
     * 最大メッセージ制限値.
     */
    private int maxMessageLength = -1 ;
    
    /**
     * 最大キューサイズ.
     */
    private int maxQueue = -1 ;
    
    /**
     * 現在キューサイズ.
     */
    private int useQueue = -1 ;
    
    /**
     * 警告キューパーセント.
     */
    private int warningPersend = -1 ;
    
    /**
     * GZIPフラグ.
     */
    private boolean gzipFlag = false ;
    
    /**
     * オートコミット.
     */
    private boolean autoCommit = false ;
    
    /**
     * キャッシュ名.
     */
    private String cacheName = null ;
    
    /**
     * ステータス.
     */
    private int state = -1 ;
    
    /**
     * 数値パラメータ.
     */
    private int[] numbers = null ;
    
    /**
     * コンストラクタ.
     */
    public AdminQueueBean() {
        
    }

    /**
     * autoCommit を取得.
     * <BR><BR>
     * @return autoCommit が返されます.
     */
    public boolean isAutoCommit() {
        return autoCommit;
    }

    /**
     * autoCommit を設定.
     * <BR><BR>
     * @param autoCommit autoCommit を設定します.
     */
    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    /**
     * gzipFlag を取得.
     * <BR><BR>
     * @return gzipFlag が返されます.
     */
    public boolean isGzipFlag() {
        return gzipFlag;
    }

    /**
     * gzipFlag を設定.
     * <BR><BR>
     * @param gzipFlag gzipFlag を設定します.
     */
    public void setGzipFlag(boolean gzipFlag) {
        this.gzipFlag = gzipFlag;
    }

    /**
     * manager を取得.
     * <BR><BR>
     * @return manager が返されます.
     */
    public String getManager() {
        return manager;
    }

    /**
     * manager を設定.
     * <BR><BR>
     * @param manager manager を設定します.
     */
    public void setManager(String manager) {
        this.manager = manager;
    }

    /**
     * maxQueue を取得.
     * <BR><BR>
     * @return maxQueue が返されます.
     */
    public int getMaxQueue() {
        return maxQueue;
    }

    /**
     * maxQueue を設定.
     * <BR><BR>
     * @param maxQueue maxQueue を設定します.
     */
    public void setMaxQueue(int maxQueue) {
        this.maxQueue = maxQueue;
    }

    /**
     * queueType を取得.
     * <BR><BR>
     * @return queueType が返されます.
     */
    public int getQueueType() {
        return queueType;
    }

    /**
     * queueType を設定.
     * <BR><BR>
     * @param queueType queueType を設定します.
     */
    public void setQueueType(int queueType) {
        this.queueType = queueType;
    }

    /**
     * state を取得.
     * <BR><BR>
     * @return state が返されます.
     */
    public int getState() {
        return state;
    }

    /**
     * state を設定.
     * <BR><BR>
     * @param state state を設定します.
     */
    public void setState(int state) {
        this.state = state;
    }

    /**
     * useQueue を取得.
     * <BR><BR>
     * @return useQueue が返されます.
     */
    public int getUseQueue() {
        return useQueue;
    }

    /**
     * useQueue を設定.
     * <BR><BR>
     * @param useQueue useQueue を設定します.
     */
    public void setUseQueue(int useQueue) {
        this.useQueue = useQueue;
    }

    /**
     * warningPersend を取得.
     * <BR><BR>
     * @return warningPersend が返されます.
     */
    public int getWarningPersend() {
        return warningPersend;
    }

    /**
     * warningPersend を設定.
     * <BR><BR>
     * @param warningPersend warningPersend を設定します.
     */
    public void setWarningPersend(int warningPersend) {
        this.warningPersend = warningPersend;
    }

    /**
     * numbers を取得.
     * <BR><BR>
     * @return numbers が返されます.
     */
    public int[] getNumbers() {
        return numbers;
    }

    /**
     * numbers を設定.
     * <BR><BR>
     * @param numbers numbers を設定します.
     */
    public void setNumbers(int[] numbers) {
        this.numbers = numbers;
    }

    /**
     * maxMessageLength を取得.
     * <BR><BR>
     * @return maxMessageLength が返されます.
     */
    public int getMaxMessageLength() {
        return maxMessageLength;
    }

    /**
     * maxMessageLength を設定.
     * <BR><BR>
     * @param maxMessageLength maxMessageLength を設定します.
     */
    public void setMaxMessageLength(int maxMessageLength) {
        this.maxMessageLength = maxMessageLength;
    }

    /**
     * cacheName を取得.
     * <BR><BR>
     * @return cacheName が返されます.
     */
    public String getCacheName() {
        return cacheName;
    }

    /**
     * cacheName を設定.
     * <BR><BR>
     * @param cacheName cacheName を設定します.
     */
    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

}

